/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.webservice;

import com.manatee.common.domain.ResultCode;
import com.manatee.common.exception.BizException;
import com.manatee.lowcode.iutil.IProcessConfUtil;
import com.manatee.lowcode.util.ProcessHandleUtil;
import com.manatee.lowcode.util.VariableUtil;
import com.manatee.process.IProcess;
import com.manatee.process.domain.ProcessContent;
import com.manatee.webservice.type.RestClient;
import com.manatee.webservice.type.SoapClient;
import javax.annotation.Resource;
import org.apache.cxf.interceptor.Fault;
import org.springframework.stereotype.Service;

@Service
public class WebServiceClientProcess
implements IProcess {
    @Resource
    private IProcessConfUtil processConfUtil;
    @Resource
    private SoapClient soapClient;
    @Resource
    private RestClient restClient;
    @Resource
    private VariableUtil variableUtil;

    public void process(ProcessContent content) throws BizException {
        this.processConfUtil.checkConf(content, new String[]{"url"});
        try {
            String runType = this.variableUtil.calVarInConf(content, "runType");
            if ("rest".equals(runType)) {
                this.restClient.handle(content);
            } else {
                this.soapClient.handle(content);
            }
        }
        catch (Throwable e2) {
            BizException e2;
            if (e2 instanceof Fault) {
                BizException bizException = new BizException(ResultCode.CONF_ERROR, "params_error");
                bizException.putDefaultParam(e2.getMessage());
                e2 = bizException;
            }
            ProcessHandleUtil.exceptionHandle((Throwable)e2);
        }
    }

    public String getName() {
        return "webServiceClient";
    }
}

