/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.kafka.config;

import com.manatee.common.util.StringUtil;
import com.manatee.config.ManateeConfig;
import com.manatee.kafka.config.ManateeKfakaConfig;
import com.manatee.kafka.domain.KafkaTopicScanThread;
import com.manatee.lowcode.web.manager.ModularityManager;
import com.manatee.manager.SpringContextManager;
import javax.annotation.Resource;
import org.apache.kafka.clients.admin.AdminClient;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.stereotype.Component;

@Component
public class ManateeKafkaConsumerInit
implements InitializingBean {
    @Resource
    private ManateeKfakaConfig manateeKfakaConfig;
    @Resource
    private ModularityManager modularityManager;
    @Resource
    private ManateeConfig manateeConfig;

    public void afterPropertiesSet() {
        KafkaTopicScanThread kafkaTopicScanThread = new KafkaTopicScanThread();
        String bootstrapServers = this.manateeConfig.getKafka().getBootstrapServers();
        String groupId = this.manateeConfig.getKafka().getConsumer().getGroupId();
        if (StringUtil.isNotBlank((String)bootstrapServers) && StringUtil.isNotBlank((String)groupId)) {
            kafkaTopicScanThread.setKfakaConfig(this.manateeKfakaConfig);
            kafkaTopicScanThread.setAdminClient((AdminClient)SpringContextManager.getBean(AdminClient.class));
            kafkaTopicScanThread.setModularityManager(this.modularityManager);
            kafkaTopicScanThread.setManateeConfig(this.manateeConfig);
            kafkaTopicScanThread.start();
        }
    }
}

