/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.camunda.process.runtime;

import com.manatee.common.domain.ResultCode;
import com.manatee.common.exception.BizException;
import com.manatee.lowcode.util.VariableUtil;
import com.manatee.process.IProcess;
import com.manatee.process.domain.ProcessContent;
import com.manatee.process.util.StringUtil;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.TaskService;
import org.camunda.bpm.engine.history.HistoricProcessInstance;
import org.camunda.bpm.engine.history.HistoricProcessInstanceQuery;
import org.camunda.bpm.engine.history.HistoricVariableInstance;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.runtime.RestartProcessInstanceBuilder;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.instance.StartEvent;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CamundaProcinsthHndleProcess
implements IProcess {
    @Resource
    private VariableUtil variableUtil;
    @Resource
    private HistoryService historyService;
    @Resource
    private RuntimeService runtimeService;
    @Resource
    private RepositoryService repositoryService;
    @Autowired
    private TaskService taskService;

    public void process(ProcessContent content) throws BizException {
        String action;
        String userId = this.getOneVarValue(content, "userId");
        String processInstanceId = this.getOneVarValue(content, "processInstanceId");
        String message = this.getOneVarValue(content, "message");
        if (StringUtil.isBlank((String)userId) || StringUtil.isBlank((String)processInstanceId)) {
            return;
        }
        HistoricProcessInstanceQuery historicProcessInstanceQuery = this.historyService.createHistoricProcessInstanceQuery();
        HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)historicProcessInstanceQuery.processInstanceId(processInstanceId).singleResult();
        if (historicProcessInstance == null) {
            throw new BizException(ResultCode.SYSTEM_ERROR, "\u6d41\u7a0b\u5b9e\u4f8b\u4e0d\u5b58\u5728,\u8bf7\u68c0\u67e5\u540e\u91cd\u8bd5");
        }
        if (!StringUtils.equals((CharSequence)historicProcessInstance.getStartUserId(), (CharSequence)userId)) {
            throw new BizException(ResultCode.BIZ_ERROR, "\u7528\u6237\u65e0\u6743\u9650,\u65e0\u6cd5\u64cd\u4f5c\u6d41\u7a0b\u5b9e\u4f8b");
        }
        if (StringUtil.isBlank((String)message)) {
            message = "";
        }
        switch (action = this.variableUtil.calVarInConf(content, "action")) {
            case "revoke": {
                ProcessInstance processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
                if (processInstance == null || processInstance.isEnded()) break;
                List taskList = this.taskService.createTaskQuery().processInstanceId(processInstanceId).active().list();
                String finalMessage = message;
                taskList.forEach(task -> this.taskService.createComment(task.getId(), processInstanceId, "revoke@@:" + finalMessage));
                this.runtimeService.deleteProcessInstance(processInstanceId, "revoke@@:" + message);
                break;
            }
            case "suspend": {
                this.runtimeService.suspendProcessInstanceById(processInstanceId);
                break;
            }
            case "activate": {
                this.runtimeService.activateProcessInstanceById(processInstanceId);
                break;
            }
            case "restart": {
                RestartProcessInstanceBuilder processInstanceBuilder = this.runtimeService.restartProcessInstances(historicProcessInstance.getProcessDefinitionId()).processInstanceIds(new String[]{processInstanceId});
                BpmnModelInstance bpmnModelInstance = this.repositoryService.getBpmnModelInstance(historicProcessInstance.getProcessDefinitionId());
                StartEvent startEvent = (StartEvent)bpmnModelInstance.getModelElementsByType(StartEvent.class).iterator().next();
                processInstanceBuilder.startBeforeActivity(startEvent.getId());
                processInstanceBuilder.execute();
                break;
            }
            case "restartRecover": {
                if (historicProcessInstance.getState().equals("EXTERNALLY_TERMINATED") || historicProcessInstance.getState().equals("INTERNALLY_TERMINATED")) {
                    RestartProcessInstanceBuilder restartProcessInstanceBuilder = this.runtimeService.restartProcessInstances(historicProcessInstance.getProcessDefinitionId()).processInstanceIds(new String[]{processInstanceId});
                    HistoricVariableInstance variables = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().processInstanceId(processInstanceId).variableName("MANATEE_REFUSE_ACTIVEIDS").singleResult();
                    if (variables != null) {
                        String activeIds = variables.getValue().toString();
                        Arrays.asList(activeIds.split(",")).forEach(arg_0 -> ((RestartProcessInstanceBuilder)restartProcessInstanceBuilder).startBeforeActivity(arg_0));
                    }
                    restartProcessInstanceBuilder.execute();
                    break;
                }
                throw new BizException(ResultCode.BIZ_ERROR, "\u975e\u7ec8\u6b62\u5de5\u4f5c\u6d41,\u65e0\u6cd5\u91cd\u542f");
            }
        }
    }

    private String getOneVarValue(ProcessContent content, String varKey) {
        Object varValueObj;
        String varKeyValue = this.variableUtil.calVarInConf(content, varKey);
        String varValue = null;
        if (StringUtil.isNotBlank((String)varKeyValue) && (varValueObj = content.getValue(varKeyValue)) != null) {
            varValue = varValueObj.toString();
        }
        return varValue;
    }

    public String getName() {
        return "camundaProcinsthHndleProcess";
    }
}

