/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.camunda.process.bpmn;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.manatee.common.domain.ResultCode;
import com.manatee.common.exception.BizException;
import com.manatee.common.util.tool.core.io.IoUtil;
import com.manatee.common.util.tool.core.util.StrUtil;
import com.manatee.common.util.tool.crypto.SecureUtil;
import com.manatee.lowcode.iutil.IOutputUtil;
import com.manatee.lowcode.util.VariableUtil;
import com.manatee.process.IProcess;
import com.manatee.process.domain.ProcessContent;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.camunda.bpm.engine.ParseException;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.repository.Deployment;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.repository.ProcessDefinitionQuery;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.AbstractFlowNodeBuilder;
import org.camunda.bpm.model.bpmn.builder.MultiInstanceLoopCharacteristicsBuilder;
import org.camunda.bpm.model.bpmn.builder.ProcessBuilder;
import org.camunda.bpm.model.bpmn.builder.ServiceTaskBuilder;
import org.camunda.bpm.model.bpmn.builder.StartEventBuilder;
import org.camunda.bpm.model.bpmn.builder.UserTaskBuilder;
import org.camunda.bpm.model.bpmn.instance.BpmnModelElementInstance;
import org.camunda.bpm.model.bpmn.instance.Process;
import org.camunda.bpm.model.bpmn.instance.ServiceTask;
import org.camunda.bpm.model.bpmn.instance.UserTask;
import org.camunda.bpm.model.bpmn.instance.camunda.CamundaProperties;
import org.camunda.bpm.model.bpmn.instance.camunda.CamundaProperty;
import org.camunda.bpm.model.xml.ModelInstance;
import org.camunda.bpm.model.xml.instance.ModelElementInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class BpmnModelCreatorProcess
implements IProcess {
    private static final Logger log = LoggerFactory.getLogger(BpmnModelCreatorProcess.class);
    @Resource
    private VariableUtil variableUtil;
    @Resource
    private RepositoryService repositoryService;
    @Resource
    private IOutputUtil outputUtil;

    public void process(ProcessContent content) throws BizException {
        StartEventBuilder start;
        String bpmnJsonString = this.variableUtil.calVarInConf(content, "processBpmn");
        JSONObject bpmnJson = JSONObject.parseObject((String)bpmnJsonString);
        String bpmnName = this.variableUtil.calVarInConf(content, "processBpmnName");
        String bpmnPic = this.variableUtil.calVarInConf(content, "processBpmnPic");
        String prcesssKey = this.variableUtil.calVarInConf(content, "prcesssKey");
        ProcessBuilder processBuilder = StringUtils.isNotBlank((CharSequence)prcesssKey) ? Bpmn.createExecutableProcess((String)prcesssKey) : Bpmn.createExecutableProcess();
        HashMap<String, Object> globalExtensionElementsMap = new HashMap<String, Object>();
        HashMap<String, JSONObject> attributeValueMap = new HashMap<String, JSONObject>();
        processBuilder.name(bpmnName);
        StartEventBuilder executableProcess = start = processBuilder.startEvent(bpmnJson.getString("id"));
        JSONObject config = bpmnJson.getJSONObject("config");
        if (config != null) {
            String initiator = config.getString("initiator");
            start.camundaInitiator(initiator);
            UserTaskBuilder userTaskBuilder = start.userTask("node_" + UUID.randomUUID());
            userTaskBuilder.name("\u53d1\u8d77\u4eba");
            userTaskBuilder.camundaAssignee("${" + initiator + "}");
            executableProcess = userTaskBuilder;
        }
        JSONObject childNode = bpmnJson.getJSONObject("childNode");
        AbstractFlowNodeBuilder bpmnModel = BpmnModelCreatorProcess.createBpmnModel(childNode, (AbstractFlowNodeBuilder)executableProcess, attributeValueMap, globalExtensionElementsMap);
        if (globalExtensionElementsMap.size() > 0) {
            ModelInstance modelInstance = ((Process)processBuilder.getElement()).getModelInstance();
            CamundaProperties camundaProperties = (CamundaProperties)modelInstance.newInstance(CamundaProperties.class);
            for (String globalKey : globalExtensionElementsMap.keySet()) {
                CamundaProperty property = (CamundaProperty)modelInstance.newInstance(CamundaProperty.class);
                property.setCamundaName(globalKey);
                property.setCamundaValue(JSONObject.toJSONString(globalExtensionElementsMap.get(globalKey)));
                camundaProperties.addChildElement((ModelElementInstance)property);
            }
            processBuilder.addExtensionElement((BpmnModelElementInstance)camundaProperties);
        }
        BpmnModelInstance bpmnModelInstance = bpmnModel.endEvent().done();
        String bpmnXml = Bpmn.convertToString((BpmnModelInstance)bpmnModelInstance);
        for (String id : attributeValueMap.keySet()) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("id=\"").append(id).append("\" ");
            JSONObject attributeJson = (JSONObject)attributeValueMap.get(id);
            for (String key : attributeJson.keySet()) {
                stringBuilder.append(key).append("=\"").append(attributeJson.getString(key)).append("\" ");
            }
            bpmnXml = bpmnXml.replace("id=\"" + id + "\"", stringBuilder.toString());
        }
        try {
            Deployment deploy = this.repositoryService.createDeployment().addString("manatee.bpmn", bpmnXml).addString("manatee.json", bpmnJsonString).addString("manatee.png", bpmnPic).name(bpmnName).deploy();
            this.outputUtil.putData(content, (Object)deploy.getId());
        }
        catch (ParseException e) {
            throw new BizException(ResultCode.CONF_ERROR, "\u89e3\u6790\u6d41\u7a0b\u56fe\u5931\u8d25" + e.getMessage());
        }
    }

    private static AbstractFlowNodeBuilder createBpmnModel(JSONObject bpmnJson, AbstractFlowNodeBuilder executableProcess, Map<String, JSONObject> attributeValueMap, Map<String, Object> globalExtensionElementsMap) throws BizException {
        if (bpmnJson == null) {
            return executableProcess;
        }
        String nodeType = bpmnJson.getString("nodeType");
        String id = "node_" + bpmnJson.getString("id");
        String name = bpmnJson.getString("name");
        switch (nodeType) {
            case "start": {
                break;
            }
            case "endEvent": {
                executableProcess.endEvent();
                break;
            }
            case "approver": 
            case "notifier": 
            case "message": {
                return BpmnModelCreatorProcess.extracted(bpmnJson, executableProcess, attributeValueMap, globalExtensionElementsMap, id, name);
            }
            case "exclusive": 
            case "parallel": 
            case "inclusive": {
                executableProcess = BpmnModelCreatorProcess.getAbstractFlowNodeBuilder(bpmnJson, executableProcess, attributeValueMap, globalExtensionElementsMap, id, nodeType);
                return executableProcess;
            }
            case "service": {
                return BpmnModelCreatorProcess.extractedByService(bpmnJson, executableProcess, attributeValueMap, globalExtensionElementsMap, id, name);
            }
            default: {
                throw new BizException(ResultCode.CONF_ERROR, "\u5347\u7ea7\u5f15\u64ce\u7248\u672c");
            }
        }
        return executableProcess;
    }

    private static AbstractFlowNodeBuilder getAbstractFlowNodeBuilder(JSONObject bpmnJson, AbstractFlowNodeBuilder executableProcess, Map<String, JSONObject> attributeValueMap, Map<String, Object> globalExtensionElementsMap, String id, String nodeType) throws BizException {
        JSONArray conditionNodeList = bpmnJson.getJSONArray("conditionNodeList");
        if (StrUtil.equals((CharSequence)nodeType, (CharSequence)"exclusive")) {
            executableProcess = executableProcess.exclusiveGateway(id);
        } else if (StrUtil.equals((CharSequence)nodeType, (CharSequence)"parallel")) {
            executableProcess = executableProcess.parallelGateway(id);
        } else if (StrUtil.equals((CharSequence)nodeType, (CharSequence)"inclusive")) {
            executableProcess = executableProcess.inclusiveGateway(id);
        }
        for (int i = 0; i < conditionNodeList.size(); ++i) {
            JSONObject conditionNode = conditionNodeList.getJSONObject(i);
            String condition = conditionNode.getJSONObject("config").getString("condition");
            String conditionName = conditionNode.getString("name");
            executableProcess = executableProcess.condition(conditionName, condition);
            JSONObject childNode1 = conditionNode.getJSONObject("childNode");
            executableProcess = BpmnModelCreatorProcess.createBpmnModel(childNode1, executableProcess, attributeValueMap, globalExtensionElementsMap);
            if (i == 0) {
                if (StrUtil.equals((CharSequence)nodeType, (CharSequence)"exclusive")) {
                    executableProcess = executableProcess.exclusiveGateway("end_" + id);
                } else if (StrUtil.equals((CharSequence)nodeType, (CharSequence)"parallel")) {
                    executableProcess = executableProcess.parallelGateway("end_" + id);
                } else if (StrUtil.equals((CharSequence)nodeType, (CharSequence)"inclusive")) {
                    executableProcess = executableProcess.inclusiveGateway("end_" + id);
                }
            } else {
                executableProcess.connectTo("end_" + id);
            }
            executableProcess = i == conditionNodeList.size() - 1 ? executableProcess.moveToNode("end_" + id) : executableProcess.moveToNode(id);
        }
        JSONObject nextChildNode = bpmnJson.getJSONObject("childNode");
        if (nextChildNode != null) {
            executableProcess = BpmnModelCreatorProcess.createBpmnModel(nextChildNode, executableProcess, attributeValueMap, globalExtensionElementsMap);
        }
        return executableProcess;
    }

    private static AbstractFlowNodeBuilder extracted(JSONObject bpmnJson, AbstractFlowNodeBuilder executableProcess, Map<String, JSONObject> attributeValueMap, Map<String, Object> globalExtensionElementsMap, String id, String name) throws BizException {
        JSONObject globalExtensionElementsJson;
        String nodeType = bpmnJson.getString("nodeType");
        JSONObject configJson = bpmnJson.getJSONObject("config");
        String assignee = configJson.getString("assignee");
        String approverType = configJson.getString("approverType");
        String groupType = configJson.getString("groupType");
        UserTaskBuilder userTaskBuilder = executableProcess.userTask(id);
        userTaskBuilder.name(name);
        String md5Assignee = SecureUtil.md5((String)assignee);
        if (assignee.contains(",")) {
            groupType = "candidateUsers";
        }
        if (StringUtils.equals((CharSequence)groupType, (CharSequence)"userId")) {
            approverType = "orSign";
        }
        if (StringUtils.equals((CharSequence)approverType, (CharSequence)"countersign")) {
            ((MultiInstanceLoopCharacteristicsBuilder)userTaskBuilder.multiInstance().camundaCollection(md5Assignee + "_collection")).camundaElementVariable("assignee");
        } else if (!StringUtils.equals((CharSequence)approverType, (CharSequence)"orSign") && StringUtils.equals((CharSequence)approverType, (CharSequence)"sequence")) {
            ((MultiInstanceLoopCharacteristicsBuilder)((MultiInstanceLoopCharacteristicsBuilder)userTaskBuilder.multiInstance().camundaCollection(md5Assignee + "_collection")).camundaElementVariable("assignee")).sequential();
        }
        if (StringUtils.equals((CharSequence)groupType, (CharSequence)"userId")) {
            userTaskBuilder.camundaAssignee(assignee);
        } else if (StringUtils.equals((CharSequence)groupType, (CharSequence)"role")) {
            if (StringUtils.equals((CharSequence)approverType, (CharSequence)"orSign")) {
                userTaskBuilder.camundaCandidateGroups(assignee);
                JSONObject attributeJson = new JSONObject();
                attributeJson.put("camunda:groupType", (Object)"role");
                attributeValueMap.put(id, attributeJson);
            } else {
                userTaskBuilder.camundaAssignee("${assignee}");
                globalExtensionElementsJson = new JSONObject();
                globalExtensionElementsJson.put("processVariableKey", (Object)(md5Assignee + "_collection"));
                globalExtensionElementsJson.put("processVariableType", (Object)"role");
                globalExtensionElementsJson.put("processVariableValue", (Object)assignee);
                BpmnModelCreatorProcess.putMap(globalExtensionElementsMap, "manatee_countersign_extended_attribute", globalExtensionElementsJson);
            }
        } else if (StringUtils.equals((CharSequence)groupType, (CharSequence)"candidateUsers")) {
            if (StringUtils.equals((CharSequence)approverType, (CharSequence)"orSign")) {
                userTaskBuilder.camundaCandidateUsers(assignee);
            } else {
                userTaskBuilder.camundaAssignee("${assignee}");
                globalExtensionElementsJson = new JSONObject();
                globalExtensionElementsJson.put("processVariableKey", (Object)(md5Assignee + "_collection"));
                globalExtensionElementsJson.put("processVariableType", (Object)"candidateUsers");
                globalExtensionElementsJson.put("processVariableValue", (Object)assignee);
                BpmnModelCreatorProcess.putMap(globalExtensionElementsMap, "manatee_countersign_extended_attribute", globalExtensionElementsJson);
            }
        }
        ModelInstance modelInstance = ((UserTask)userTaskBuilder.getElement()).getModelInstance();
        CamundaProperties camundaProperties = (CamundaProperties)modelInstance.newInstance(CamundaProperties.class);
        BpmnModelCreatorProcess.refuseStrategyExtensionElement(configJson, modelInstance, camundaProperties);
        BpmnModelCreatorProcess.pageUrlExtensionElement(configJson, modelInstance, camundaProperties);
        BpmnModelCreatorProcess.formConfigExtensionElement(configJson, modelInstance, camundaProperties);
        BpmnModelCreatorProcess.actionExtensionElement(configJson, modelInstance, camundaProperties);
        BpmnModelCreatorProcess.extendedExtensionElement(configJson, modelInstance, camundaProperties);
        BpmnModelCreatorProcess.notifierExtensionElement(nodeType, configJson, modelInstance, camundaProperties);
        userTaskBuilder.addExtensionElement((BpmnModelElementInstance)camundaProperties);
        executableProcess = userTaskBuilder;
        JSONObject childNode = bpmnJson.getJSONObject("childNode");
        if (childNode != null) {
            executableProcess = BpmnModelCreatorProcess.createBpmnModel(childNode, executableProcess, attributeValueMap, globalExtensionElementsMap);
        }
        return executableProcess;
    }

    private static AbstractFlowNodeBuilder extractedByService(JSONObject bpmnJson, AbstractFlowNodeBuilder executableProcess, Map<String, JSONObject> attributeValueMap, Map<String, Object> globalExtensionElementsMap, String id, String name) throws BizException {
        JSONObject configJson = bpmnJson.getJSONObject("config");
        String executingType = configJson.getString("executingType");
        String executingValue = configJson.getString("executingValue");
        ServiceTaskBuilder serviceTaskBuilder = executableProcess.serviceTask(id);
        serviceTaskBuilder.name(name);
        if (StringUtils.equals((CharSequence)executingType, (CharSequence)"class")) {
            serviceTaskBuilder.camundaClass(executingValue);
        } else if (StringUtils.equals((CharSequence)executingType, (CharSequence)"flowChart")) {
            serviceTaskBuilder.camundaClass("com.manatee.camunda.listener.ManateeJavaDelegate");
            String projectId = configJson.getString("projectId");
            String moduleCode = configJson.getString("moduleCode");
            JSONObject attributeJson = new JSONObject();
            attributeJson.put("MANATEE_PROJECT_ID", (Object)projectId);
            attributeJson.put("MANATEE_MODULE_CODE", (Object)moduleCode);
            attributeValueMap.put(id, attributeJson);
        }
        ModelInstance modelInstance = ((ServiceTask)serviceTaskBuilder.getElement()).getModelInstance();
        CamundaProperties camundaProperties = (CamundaProperties)modelInstance.newInstance(CamundaProperties.class);
        BpmnModelCreatorProcess.pageUrlExtensionElement(configJson, modelInstance, camundaProperties);
        serviceTaskBuilder.addExtensionElement((BpmnModelElementInstance)camundaProperties);
        executableProcess = serviceTaskBuilder;
        JSONObject childNode = bpmnJson.getJSONObject("childNode");
        if (childNode != null) {
            executableProcess = BpmnModelCreatorProcess.createBpmnModel(childNode, executableProcess, attributeValueMap, globalExtensionElementsMap);
        }
        return executableProcess;
    }

    private static void pageUrlExtensionElement(JSONObject configJson, ModelInstance modelInstance, CamundaProperties camundaProperties) {
        CamundaProperty property;
        String manatee_pc_page_url = configJson.getString("manatee_pc_page_url");
        String manatee_h5_page_url = configJson.getString("manatee_h5_page_url");
        if (StringUtils.isNotBlank((CharSequence)manatee_pc_page_url)) {
            property = (CamundaProperty)modelInstance.newInstance(CamundaProperty.class);
            property.setCamundaName("manatee_pc_page_url");
            property.setCamundaValue(manatee_pc_page_url);
            camundaProperties.addChildElement((ModelElementInstance)property);
        }
        if (StringUtils.isNotBlank((CharSequence)manatee_h5_page_url)) {
            property = (CamundaProperty)modelInstance.newInstance(CamundaProperty.class);
            property.setCamundaName("manatee_h5_page_url");
            property.setCamundaValue(manatee_h5_page_url);
            camundaProperties.addChildElement((ModelElementInstance)property);
        }
    }

    private static void formConfigExtensionElement(JSONObject configJson, ModelInstance modelInstance, CamundaProperties camundaProperties) {
        String formConfig = configJson.getString("formConfig");
        if (StringUtils.isNotBlank((CharSequence)formConfig)) {
            CamundaProperty property = (CamundaProperty)modelInstance.newInstance(CamundaProperty.class);
            property.setCamundaName("formConfig");
            property.setCamundaValue(formConfig);
            camundaProperties.addChildElement((ModelElementInstance)property);
        }
    }

    private static void actionExtensionElement(JSONObject configJson, ModelInstance modelInstance, CamundaProperties camundaProperties) {
        String actions = configJson.getString("actions");
        if (StringUtils.isNotBlank((CharSequence)actions)) {
            JSONArray actionArr = JSONArray.parseArray((String)actions);
            StringBuffer actionStr = new StringBuffer();
            for (Object action : actionArr) {
                JSONObject actionJson = (JSONObject)action;
                String name = actionJson.getString("name");
                String button = actionJson.getString("button");
                if (StringUtils.isNotBlank((CharSequence)button)) {
                    name = button;
                }
                actionStr.append(actionJson.getString("code")).append(":").append(name).append(";");
            }
            CamundaProperty property = (CamundaProperty)modelInstance.newInstance(CamundaProperty.class);
            property.setCamundaName("actions");
            property.setCamundaValue(actionStr.toString());
            camundaProperties.addChildElement((ModelElementInstance)property);
        }
    }

    private static void extendedExtensionElement(JSONObject configJson, ModelInstance modelInstance, CamundaProperties camundaProperties) {
        String extended = configJson.getString("extended");
        if (StringUtils.isNotBlank((CharSequence)extended)) {
            JSONArray extendedArr = JSONArray.parseArray((String)extended);
            for (Object extendedObj : extendedArr) {
                JSONObject extendedJson = (JSONObject)extendedObj;
                CamundaProperty property = (CamundaProperty)modelInstance.newInstance(CamundaProperty.class);
                property.setCamundaName(extendedJson.getString("name"));
                property.setCamundaValue(extendedJson.getString("code"));
                camundaProperties.addChildElement((ModelElementInstance)property);
            }
        }
    }

    private static void refuseStrategyExtensionElement(JSONObject configJson, ModelInstance modelInstance, CamundaProperties camundaProperties) {
        String refuseStrategyValue = configJson.getString("refuseStrategy");
        if (StringUtils.isNotBlank((CharSequence)refuseStrategyValue)) {
            CamundaProperty property = (CamundaProperty)modelInstance.newInstance(CamundaProperty.class);
            property.setCamundaName("refuseStrategy");
            property.setCamundaValue(refuseStrategyValue);
            camundaProperties.addChildElement((ModelElementInstance)property);
        }
    }

    private static void notifierExtensionElement(String nodeType, JSONObject configJson, ModelInstance modelInstance, CamundaProperties camundaProperties) {
        if (StringUtils.equals((CharSequence)nodeType, (CharSequence)"notifier") || StringUtils.equals((CharSequence)nodeType, (CharSequence)"message")) {
            CamundaProperty property = (CamundaProperty)modelInstance.newInstance(CamundaProperty.class);
            property.setCamundaName("nodeType");
            property.setCamundaValue("2");
            camundaProperties.addChildElement((ModelElementInstance)property);
            if (StringUtils.equals((CharSequence)nodeType, (CharSequence)"message")) {
                CamundaProperty messageProperty;
                String type = configJson.getString("type");
                String title = configJson.getString("title");
                String content = configJson.getString("content");
                if (StringUtils.isNotBlank((CharSequence)type)) {
                    messageProperty = (CamundaProperty)modelInstance.newInstance(CamundaProperty.class);
                    messageProperty.setCamundaName("messageType");
                    messageProperty.setCamundaValue(type);
                    camundaProperties.addChildElement((ModelElementInstance)messageProperty);
                }
                if (StringUtils.isNotBlank((CharSequence)title)) {
                    messageProperty = (CamundaProperty)modelInstance.newInstance(CamundaProperty.class);
                    messageProperty.setCamundaName("messageTitle");
                    messageProperty.setCamundaValue(title);
                    camundaProperties.addChildElement((ModelElementInstance)messageProperty);
                }
                if (StringUtils.isNotBlank((CharSequence)content)) {
                    messageProperty = (CamundaProperty)modelInstance.newInstance(CamundaProperty.class);
                    messageProperty.setCamundaName("messageContent");
                    messageProperty.setCamundaValue(content);
                    camundaProperties.addChildElement((ModelElementInstance)messageProperty);
                }
            }
        }
    }

    private static void putMap(Map<String, Object> globalExtensionElementsMap, String key, JSONObject json) {
        if (globalExtensionElementsMap.containsKey(key)) {
            List orgList = (List)globalExtensionElementsMap.get(key);
            orgList.add(json);
        } else {
            ArrayList<JSONObject> list = new ArrayList<JSONObject>();
            list.add(json);
            globalExtensionElementsMap.put(key, list);
        }
    }

    public String getName() {
        return "bpmnModelCreatorProcess";
    }

    public String getBpmnJson(String deploymentId, String prcesssKey) {
        if (StrUtil.isBlank((CharSequence)deploymentId) && StrUtil.isBlank((CharSequence)prcesssKey)) {
            return "{}";
        }
        ProcessDefinitionQuery processDefinitionQuery = this.repositoryService.createProcessDefinitionQuery();
        if (StrUtil.isNotBlank((CharSequence)deploymentId)) {
            processDefinitionQuery.deploymentId(deploymentId);
        } else if (StrUtil.isNotBlank((CharSequence)prcesssKey)) {
            processDefinitionQuery.processDefinitionKey(prcesssKey).latestVersion();
        }
        ProcessDefinition processDefinition = (ProcessDefinition)processDefinitionQuery.singleResult();
        InputStream bpmnJson = this.repositoryService.getResourceAsStream(processDefinition.getDeploymentId(), "manatee.json");
        String bpmnJsonStr = IoUtil.read((InputStream)bpmnJson, (Charset)Charset.defaultCharset());
        return bpmnJsonStr;
    }
}

