/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.redis.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.manatee.redis.domain.RedisDO;
import com.manatee.redis.util.ManateeRedisUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class RedisDbManager {
    private static String conf = "conf:redisdb";
    private static Integer dbIndex = 6;
    private static long UPDATE_TIME = 1200000L;
    private static Map<String, Long> TIME_MAP = new ConcurrentHashMap<String, Long>();
    private static Map<String, RedisDO> REDISDO_MAP = new HashMap<String, RedisDO>();

    private static JSONObject getConf() {
        String value = ManateeRedisUtil.getValue(dbIndex, conf);
        if (value == null) {
            return null;
        }
        JSONObject result = JSON.parseObject((String)value);
        return result;
    }

    public static int getDbIndex(String name) {
        RedisDO redisDO = RedisDbManager.getRedisDO(name);
        return redisDO.getDbIndex();
    }

    public static RedisDO getRedisDO(String name) {
        RedisDO redisDO;
        Long lastTime = TIME_MAP.get(name);
        if (lastTime == null) {
            lastTime = 0L;
        }
        if (System.currentTimeMillis() - lastTime > UPDATE_TIME) {
            REDISDO_MAP.clear();
            TIME_MAP.clear();
            RedisDbManager.putRedisDO();
        }
        if ((redisDO = REDISDO_MAP.get(name)) == null) {
            redisDO = new RedisDO(dbIndex, null);
        }
        return redisDO;
    }

    private static void putRedisDO() {
        JSONObject confs = RedisDbManager.getConf();
        Set keys = confs.keySet();
        for (String confkey : keys) {
            JSONObject jobj = confs.getJSONObject(confkey);
            int db = jobj.getInteger("db");
            String key = null;
            if (jobj.containsKey((Object)"key")) {
                key = jobj.getString("key");
            }
            REDISDO_MAP.put(confkey, new RedisDO(db, key));
            TIME_MAP.put(confkey, System.currentTimeMillis());
        }
    }

    public void setDbIndex(Integer dbIndex) {
        RedisDbManager.dbIndex = dbIndex;
    }

    public void setConf(String conf) {
        RedisDbManager.conf = conf;
    }
}

