/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.redis.util;

import com.manatee.common.util.StringUtil;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.jedis.exceptions.JedisConnectionException;

@Service
public class RedisClientInit
implements InitializingBean {
    protected static Logger log = LoggerFactory.getLogger(RedisClientInit.class);
    @Value(value="${spring.redis.host:}")
    private String hostInSpringRedis;
    @Value(value="${spring.redis.port:}")
    private String portInSpringRedis;
    @Value(value="${spring.redis.password:}")
    private String passwordInSpringRedis;
    @Value(value="${redis.host:}")
    private String hostInRedis;
    @Value(value="${redis.port:}")
    private String portInRedis;
    @Value(value="${redis.password:}")
    private String passwordInRedis;
    private JedisPool writePool;
    private JedisPool readPool;

    private JedisPool createJedisPool(String host, Integer port, String password) {
        JedisPoolConfig config = new JedisPoolConfig();
        config.setMaxIdle(8);
        config.setMaxTotal(50);
        config.setMaxWaitMillis(100000L);
        JedisPool pool = null;
        pool = StringUtils.isBlank((CharSequence)password) ? new JedisPool((GenericObjectPoolConfig)config, host, port.intValue(), 10000) : new JedisPool((GenericObjectPoolConfig)config, host, port.intValue(), 10000, password);
        return pool;
    }

    private Map<String, String> getRedisProperties() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("host", StringUtil.isNotBlank((String)this.hostInSpringRedis) ? this.hostInSpringRedis : this.hostInRedis);
        String port = StringUtil.isNotBlank((String)this.portInSpringRedis) ? this.portInSpringRedis : this.portInRedis;
        map.put("port", StringUtil.isNotBlank((String)port) ? port : "6379");
        map.put("password", StringUtil.isNotBlank((String)this.passwordInSpringRedis) ? this.passwordInSpringRedis : this.passwordInRedis);
        return map;
    }

    public void poolReadInit(JedisPool pool) {
        if (pool == null) {
            Map<String, String> redisProperties = this.getRedisProperties();
            this.readPool = this.createJedisPool(redisProperties.get("host"), Integer.valueOf(redisProperties.get("port")), redisProperties.get("password"));
        }
    }

    public void poolWriteInit(JedisPool pool) {
        if (pool == null) {
            Map<String, String> redisProperties = this.getRedisProperties();
            this.writePool = this.createJedisPool(redisProperties.get("host"), Integer.valueOf(redisProperties.get("port")), redisProperties.get("password"));
        }
    }

    public Jedis getReadJedis() {
        this.poolReadInit(this.readPool);
        return this.getJedis(this.readPool);
    }

    public Jedis getWriteJedis() {
        this.poolWriteInit(this.writePool);
        return this.getJedis(this.writePool);
    }

    public void closePool(JedisPool pool) {
        if (pool != null) {
            pool.destroy();
        }
    }

    public Jedis getJedis(JedisPool pool) {
        Jedis jedis = null;
        try {
            jedis = pool.getResource();
        }
        catch (JedisConnectionException e) {
            pool = null;
            log.error("[RedisClientInit.getReadyOnlyJedis]_exception", (Object)"getResource is fail", (Object)e);
        }
        return jedis;
    }

    public void returnRes(Jedis jedis) {
        if (jedis != null) {
            jedis.close();
        }
    }

    public void afterPropertiesSet() throws Exception {
        this.poolReadInit(this.readPool);
        this.poolWriteInit(this.writePool);
    }

    public String getHostInSpringRedis() {
        return this.hostInSpringRedis;
    }

    public String getPortInSpringRedis() {
        return this.portInSpringRedis;
    }

    public String getPasswordInSpringRedis() {
        return this.passwordInSpringRedis;
    }

    public String getHostInRedis() {
        return this.hostInRedis;
    }

    public String getPortInRedis() {
        return this.portInRedis;
    }

    public String getPasswordInRedis() {
        return this.passwordInRedis;
    }

    public JedisPool getWritePool() {
        return this.writePool;
    }

    public JedisPool getReadPool() {
        return this.readPool;
    }

    public void setHostInSpringRedis(String hostInSpringRedis) {
        this.hostInSpringRedis = hostInSpringRedis;
    }

    public void setPortInSpringRedis(String portInSpringRedis) {
        this.portInSpringRedis = portInSpringRedis;
    }

    public void setPasswordInSpringRedis(String passwordInSpringRedis) {
        this.passwordInSpringRedis = passwordInSpringRedis;
    }

    public void setHostInRedis(String hostInRedis) {
        this.hostInRedis = hostInRedis;
    }

    public void setPortInRedis(String portInRedis) {
        this.portInRedis = portInRedis;
    }

    public void setPasswordInRedis(String passwordInRedis) {
        this.passwordInRedis = passwordInRedis;
    }

    public void setWritePool(JedisPool writePool) {
        this.writePool = writePool;
    }

    public void setReadPool(JedisPool readPool) {
        this.readPool = readPool;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RedisClientInit)) {
            return false;
        }
        RedisClientInit other = (RedisClientInit)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$hostInSpringRedis = this.getHostInSpringRedis();
        String other$hostInSpringRedis = other.getHostInSpringRedis();
        if (this$hostInSpringRedis == null ? other$hostInSpringRedis != null : !this$hostInSpringRedis.equals(other$hostInSpringRedis)) {
            return false;
        }
        String this$portInSpringRedis = this.getPortInSpringRedis();
        String other$portInSpringRedis = other.getPortInSpringRedis();
        if (this$portInSpringRedis == null ? other$portInSpringRedis != null : !this$portInSpringRedis.equals(other$portInSpringRedis)) {
            return false;
        }
        String this$passwordInSpringRedis = this.getPasswordInSpringRedis();
        String other$passwordInSpringRedis = other.getPasswordInSpringRedis();
        if (this$passwordInSpringRedis == null ? other$passwordInSpringRedis != null : !this$passwordInSpringRedis.equals(other$passwordInSpringRedis)) {
            return false;
        }
        String this$hostInRedis = this.getHostInRedis();
        String other$hostInRedis = other.getHostInRedis();
        if (this$hostInRedis == null ? other$hostInRedis != null : !this$hostInRedis.equals(other$hostInRedis)) {
            return false;
        }
        String this$portInRedis = this.getPortInRedis();
        String other$portInRedis = other.getPortInRedis();
        if (this$portInRedis == null ? other$portInRedis != null : !this$portInRedis.equals(other$portInRedis)) {
            return false;
        }
        String this$passwordInRedis = this.getPasswordInRedis();
        String other$passwordInRedis = other.getPasswordInRedis();
        if (this$passwordInRedis == null ? other$passwordInRedis != null : !this$passwordInRedis.equals(other$passwordInRedis)) {
            return false;
        }
        JedisPool this$writePool = this.getWritePool();
        JedisPool other$writePool = other.getWritePool();
        if (this$writePool == null ? other$writePool != null : !this$writePool.equals(other$writePool)) {
            return false;
        }
        JedisPool this$readPool = this.getReadPool();
        JedisPool other$readPool = other.getReadPool();
        return !(this$readPool == null ? other$readPool != null : !this$readPool.equals(other$readPool));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RedisClientInit;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $hostInSpringRedis = this.getHostInSpringRedis();
        result = result * 59 + ($hostInSpringRedis == null ? 43 : $hostInSpringRedis.hashCode());
        String $portInSpringRedis = this.getPortInSpringRedis();
        result = result * 59 + ($portInSpringRedis == null ? 43 : $portInSpringRedis.hashCode());
        String $passwordInSpringRedis = this.getPasswordInSpringRedis();
        result = result * 59 + ($passwordInSpringRedis == null ? 43 : $passwordInSpringRedis.hashCode());
        String $hostInRedis = this.getHostInRedis();
        result = result * 59 + ($hostInRedis == null ? 43 : $hostInRedis.hashCode());
        String $portInRedis = this.getPortInRedis();
        result = result * 59 + ($portInRedis == null ? 43 : $portInRedis.hashCode());
        String $passwordInRedis = this.getPasswordInRedis();
        result = result * 59 + ($passwordInRedis == null ? 43 : $passwordInRedis.hashCode());
        JedisPool $writePool = this.getWritePool();
        result = result * 59 + ($writePool == null ? 43 : $writePool.hashCode());
        JedisPool $readPool = this.getReadPool();
        result = result * 59 + ($readPool == null ? 43 : $readPool.hashCode());
        return result;
    }

    public String toString() {
        return "RedisClientInit(hostInSpringRedis=" + this.getHostInSpringRedis() + ", portInSpringRedis=" + this.getPortInSpringRedis() + ", passwordInSpringRedis=" + this.getPasswordInSpringRedis() + ", hostInRedis=" + this.getHostInRedis() + ", portInRedis=" + this.getPortInRedis() + ", passwordInRedis=" + this.getPasswordInRedis() + ", writePool=" + this.getWritePool() + ", readPool=" + this.getReadPool() + ")";
    }
}

