/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.redis.process;

import com.alibaba.fastjson.JSONObject;
import com.manatee.common.domain.ResultCode;
import com.manatee.common.exception.BizException;
import com.manatee.common.util.StringUtil;
import com.manatee.lowcode.iutil.IOutputUtil;
import com.manatee.lowcode.iutil.IProcessConfUtil;
import com.manatee.lowcode.iutil.IVariableUtil;
import com.manatee.process.IProcess;
import com.manatee.process.domain.ProcessContent;
import com.manatee.process.domain.Step;
import com.manatee.redis.source.DtSourceManager;
import com.manatee.redis.util.RedisDbUtil;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class RedisListQueryProcess
implements IProcess {
    private Logger log = LoggerFactory.getLogger(RedisListQueryProcess.class);
    @Resource
    private DtSourceManager dtSourceManager;
    @Resource
    private IOutputUtil outputUtil;
    @Resource
    private IVariableUtil variableUtil;
    @Resource
    private IProcessConfUtil processConfUtil;

    public void process(ProcessContent content) throws BizException {
        Step step = content.getStep();
        JSONObject conf = step.getConf();
        this.processConfUtil.checkConf(content, new String[]{"key"});
        int db = RedisDbUtil.getRedisDB(content);
        long start = 0L;
        long end = -1L;
        if (conf.containsKey((Object)"start")) {
            start = conf.getInteger("start").intValue();
        }
        if (conf.containsKey((Object)"end")) {
            end = conf.getInteger("end").intValue();
        }
        String objectKey = this.variableUtil.calVarInConf(content, "key");
        List<String> resultList = this.dtSourceManager.getDtSource().getList(db, objectKey, start, end);
        if (StringUtil.isBlank((String)conf.getString("returnKey"))) {
            content.getStepConf().put("returnKey", (Object)objectKey);
        }
        if (resultList == null || resultList.size() == 0) {
            this.log.warn("[GetRedisListValuesProcess.process]_biz_occur,msg:{}", (Object)("result_is_null,key:" + objectKey));
            throw new BizException(ResultCode.RESULT_IS_NULL, "result_is_null");
        }
        this.outputUtil.handleAndPutData(content, resultList);
        this.log.warn("[GetRedisListValuesProcess.process]_biz_occur,msg:{}", (Object)("key:" + objectKey));
    }

    public String getName() {
        return "redisListQuery";
    }
}

