/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.lowcode.sql.listener;

import com.manatee.lowcode.sql.MySqlParser;
import com.manatee.lowcode.sql.MySqlParserBaseListener;
import java.util.ArrayList;
import java.util.List;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DdlMySqlParserBaseListener
extends MySqlParserBaseListener {
    private static final Logger log = LoggerFactory.getLogger(DdlMySqlParserBaseListener.class);
    private List<String> ddlList = new ArrayList<String>();

    @Override
    public void enterSqlStatements(MySqlParser.SqlStatementsContext ctx) {
        super.enterSqlStatements(ctx);
        this.child((ParseTree)ctx);
    }

    @Override
    public void exitSqlStatements(MySqlParser.SqlStatementsContext ctx) {
        super.exitSqlStatements(ctx);
    }

    private void child(ParseTree child) {
        if (child.getChildCount() > 0) {
            int count = child.getChildCount();
            for (int i = 0; i < count; ++i) {
                ParseTree child1 = child.getChild(i);
                StringBuilder ddlStr = new StringBuilder();
                this.ddl(child1, ddlStr);
                if (ddlStr.length() <= 0) continue;
                ddlStr.append(";");
                this.ddlList.add(ddlStr.toString());
            }
        }
    }

    private void ddl(ParseTree child, StringBuilder ddlStr) {
        if (child == null) {
            return;
        }
        if (child.getChildCount() <= 0) {
            String text = child.getText();
            if (StringUtils.equals((CharSequence)text, (CharSequence)";")) {
                return;
            }
            ddlStr.append(child.getText()).append(" ");
            return;
        }
        int count = child.getChildCount();
        for (int j = 0; j < count; ++j) {
            ParseTree child1 = child.getChild(j);
            this.ddl(child1, ddlStr);
        }
    }

    public List<String> getDdlList() {
        return this.ddlList;
    }
}

