/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.fun.impl.cal;

import com.manatee.fun.AbstractFunction;
import com.manatee.fun.domain.FunctionContent;
import com.manatee.fun.util.FunctionContentUtil;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class MinValueFun
extends AbstractFunction {
    private static Logger log = LoggerFactory.getLogger(MinValueFun.class);
    private String name = "minValue";

    public String getName() {
        return this.name;
    }

    public Object doFunction(FunctionContent content) {
        this.checkParamSize(content);
        if (!this.checkParamExist(content).booleanValue()) {
            return null;
        }
        List parameters = content.getParameters();
        Object aValue = parameters.get(0);
        try {
            if (aValue instanceof List) {
                List list = (List)aValue;
                return this.getMin(list);
            }
            return this.getMin(content.getParameters());
        }
        catch (Throwable e) {
            log.error("[MinValueFun.doFunction]_exception", e);
            FunctionContentUtil.addUnBlockError((FunctionContent)content, (String)String.format("\u51fd\u6570\uff1a%s\uff0c\u83b7\u53d6\u6700\u5c0f\u503c\u5931\u8d25", this.getName()), (String)this.getName());
            return null;
        }
    }

    public Object getMin(List<Object> list) {
        if (list.size() == 0) {
            return null;
        }
        Object min = list.get(0);
        Double doubleMin = Double.valueOf(min + "");
        for (Object aValue : list) {
            Double doubleValue = Double.valueOf(aValue + "");
            if (!(doubleMin > doubleValue)) continue;
            doubleMin = doubleValue;
            min = aValue;
        }
        return min;
    }

    public static void main(String[] args) {
        MinValueFun fun = new MinValueFun();
        ArrayList<Double> values = new ArrayList<Double>();
        values.add(0.3058);
        values.add(0.3978);
        values.add(0.1386);
        FunctionContent content = new FunctionContent();
        content.setParameters(values);
        System.out.println(fun.doFunction(content));
    }

    public Integer getMinParamSize() {
        return 1;
    }

    public Integer getMaxParamSize() {
        return Integer.MAX_VALUE;
    }
}

