/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.file.process;

import com.alibaba.fastjson.JSON;
import com.github.tobato.fastdfs.domain.StorePath;
import com.github.tobato.fastdfs.service.FastFileStorageClient;
import com.manatee.common.domain.ResultCode;
import com.manatee.common.exception.BizException;
import com.manatee.common.util.StringUtil;
import com.manatee.lowcode.iutil.IOutputUtil;
import com.manatee.lowcode.iutil.IVariableUtil;
import com.manatee.process.IProcess;
import com.manatee.process.domain.ProcessContent;
import com.manatee.process.domain.ProcessFileInfo;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Service;

@Service
@ConditionalOnProperty(value={"fdfs.reqHost"})
public class FdfsUploadProcess
implements IProcess {
    @Resource
    private IVariableUtil variableUtil;
    @Resource
    protected IOutputUtil outputUtil;
    @Autowired
    private FastFileStorageClient fastFileStorageClient;

    public void process(ProcessContent content) throws BizException {
        InputStream file = content.getFile();
        String fileName = content.getFileName();
        String base64Key = this.variableUtil.calVarInConf(content, "base64");
        Object base64Value = content.getValue(base64Key);
        String url = "";
        String urlKey = "url";
        List fileInfoList = content.getFiles();
        String localFilePath = this.variableUtil.calVarInConf(content, "localFilePath");
        if (file != null) {
            String suffix = fileName.substring(fileName.lastIndexOf(".") + 1);
            url = this.uploadFile(file, suffix);
        } else if (fileInfoList != null && fileInfoList.size() > 0) {
            urlKey = "urls";
            ArrayList<String> urls = new ArrayList<String>(fileInfoList.size());
            for (ProcessFileInfo processFileInfo : fileInfoList) {
                InputStream fileInfo = processFileInfo.getInputStream();
                String fileInfoName = processFileInfo.getFileName();
                String suffixName = fileInfoName.substring(fileInfoName.lastIndexOf(".") + 1);
                String fileUrl = this.uploadFile(fileInfo, suffixName);
                urls.add(fileUrl);
            }
            url = JSON.toJSONString(urls);
        } else if (base64Value != null && StringUtil.isNotBlank((String)base64Value.toString())) {
            String[] base64Array = base64Value.toString().split(";");
            String base = base64Array[1].split(",")[1];
            byte[] imageByte = Base64.getDecoder().decode(base);
            String suffix = base64Array[0].split("/")[1];
            ByteArrayInputStream baseInputStream = new ByteArrayInputStream(imageByte);
            StorePath storePath = this.fastFileStorageClient.uploadFile((InputStream)baseInputStream, (long)baseInputStream.available(), suffix, new HashSet());
            url = storePath.getFullPath();
        } else if (StringUtil.isNotBlank((String)localFilePath)) {
            FileInputStream inputStream;
            Boolean needDel = content.getStepConf().getBoolean("needDel");
            String suffixName = localFilePath.substring(localFilePath.lastIndexOf(".") + 1);
            File file1 = new File(localFilePath);
            try {
                inputStream = new FileInputStream(file1);
            }
            catch (FileNotFoundException e) {
                throw new BizException(ResultCode.PARAM_IS_ERROR, "file not found", (Throwable)e);
            }
            url = this.uploadFile(inputStream, suffixName);
            try {
                if (inputStream != null) {
                    ((InputStream)inputStream).close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (needDel != null && file1 != null && needDel.booleanValue() && file1.exists()) {
                file1.delete();
            }
        } else {
            throw new BizException(ResultCode.PARAM_IS_ERROR, "file/base64 \u672a\u586b");
        }
        this.outputUtil.setDefaultReturnKey(content, urlKey);
        this.outputUtil.putData(content, (Object)url);
    }

    private String uploadFile(InputStream file, String suffix) {
        String url = "";
        try {
            StorePath storePath = this.fastFileStorageClient.uploadFile(file, (long)file.available(), suffix, new HashSet());
            url = storePath.getFullPath();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return url;
    }

    public String getName() {
        return "fdfsUpload";
    }
}

