/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.common.util.tool.crypto.asymmetric;

import com.manatee.common.util.tool.core.lang.Assert;
import com.manatee.common.util.tool.core.util.HexUtil;
import com.manatee.common.util.tool.crypto.BCUtil;
import com.manatee.common.util.tool.crypto.CryptoException;
import com.manatee.common.util.tool.crypto.KeyUtil;
import com.manatee.common.util.tool.crypto.SecureUtil;
import com.manatee.common.util.tool.crypto.asymmetric.AbstractAsymmetricCrypto;
import com.manatee.common.util.tool.crypto.asymmetric.KeyType;
import java.security.PrivateKey;
import java.security.PublicKey;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.engines.SM2Engine;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.crypto.signers.SM2Signer;

public class SM2
extends AbstractAsymmetricCrypto<SM2> {
    private static final String ALGORITHM_SM2 = "SM2";
    protected SM2Engine engine;
    protected SM2Signer signer;
    private ECPrivateKeyParameters privateKeyParams;
    private ECPublicKeyParameters publicKeyParams;

    public SM2() {
        this(null, (byte[])null);
    }

    public SM2(String privateKeyStr, String publicKeyStr) {
        this(SecureUtil.decode(privateKeyStr), SecureUtil.decode(publicKeyStr));
    }

    public SM2(byte[] privateKey, byte[] publicKey) {
        this(KeyUtil.generatePrivateKey(ALGORITHM_SM2, privateKey), KeyUtil.generatePublicKey(ALGORITHM_SM2, publicKey));
    }

    public SM2(PrivateKey privateKey, PublicKey publicKey) {
        this(BCUtil.toParams(privateKey), BCUtil.toParams(publicKey));
        if (null != privateKey) {
            this.privateKey = privateKey;
        }
        if (null != publicKey) {
            this.publicKey = publicKey;
        }
    }

    public SM2(String privateKeyHex, String publicKeyPointXHex, String publicKeyPointYHex) {
        this(BCUtil.toSm2Params(privateKeyHex), BCUtil.toSm2Params(publicKeyPointXHex, publicKeyPointYHex));
    }

    public SM2(byte[] privateKey, byte[] publicKeyPointX, byte[] publicKeyPointY) {
        this(BCUtil.toSm2Params(privateKey), BCUtil.toSm2Params(publicKeyPointX, publicKeyPointY));
    }

    public SM2(ECPrivateKeyParameters privateKeyParams, ECPublicKeyParameters publicKeyParams) {
        super(ALGORITHM_SM2, null, null);
        this.privateKeyParams = privateKeyParams;
        this.publicKeyParams = publicKeyParams;
        this.init();
    }

    public SM2 init() {
        if (null == this.privateKeyParams && null == this.publicKeyParams) {
            super.initKeys();
            this.privateKeyParams = BCUtil.toParams(this.privateKey);
            this.publicKeyParams = BCUtil.toParams(this.publicKey);
        }
        return this;
    }

    @Override
    public SM2 initKeys() {
        return this;
    }

    @Override
    public byte[] encrypt(byte[] data, KeyType keyType) throws CryptoException {
        if (KeyType.PublicKey != keyType) {
            throw new IllegalArgumentException("Encrypt is only support by public key");
        }
        return this.encrypt(data, (CipherParameters)new ParametersWithRandom(this.getCipherParameters(keyType)));
    }

    public byte[] encrypt(byte[] data, CipherParameters pubKeyParameters) throws CryptoException {
        this.lock.lock();
        SM2Engine engine = this.getEngine();
        try {
            engine.init(true, pubKeyParameters);
            byte[] byArray = engine.processBlock(data, 0, data.length);
            return byArray;
        }
        catch (InvalidCipherTextException e) {
            throw new CryptoException(e);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public byte[] decrypt(byte[] data, KeyType keyType) throws CryptoException {
        if (KeyType.PrivateKey != keyType) {
            throw new IllegalArgumentException("Decrypt is only support by private key");
        }
        return this.decrypt(data, this.getCipherParameters(keyType));
    }

    public byte[] decrypt(byte[] data, CipherParameters privateKeyParameters) throws CryptoException {
        this.lock.lock();
        SM2Engine engine = this.getEngine();
        try {
            engine.init(false, privateKeyParameters);
            byte[] byArray = engine.processBlock(data, 0, data.length);
            return byArray;
        }
        catch (InvalidCipherTextException e) {
            throw new CryptoException(e);
        }
        finally {
            this.lock.unlock();
        }
    }

    public String signHex(String dataHex) {
        return this.signHex(dataHex, null);
    }

    public byte[] sign(byte[] data) {
        return this.sign(data, null);
    }

    public String signHex(String dataHex, String idHex) {
        return HexUtil.encodeHexStr(this.sign(HexUtil.decodeHex(dataHex), HexUtil.decodeHex(idHex)));
    }

    public byte[] sign(byte[] data, byte[] id) {
        return null;
    }

    public boolean verifyHex(String dataHex, String signHex) {
        return this.verifyHex(dataHex, signHex, null);
    }

    public boolean verify(byte[] data, byte[] sign) {
        return this.verify(data, sign, null);
    }

    public boolean verifyHex(String dataHex, String signHex, String idHex) {
        return this.verify(HexUtil.decodeHex(dataHex), HexUtil.decodeHex(signHex), HexUtil.decodeHex(idHex));
    }

    public boolean verify(byte[] data, byte[] sign, byte[] id) {
        return false;
    }

    @Override
    public SM2 setPrivateKey(PrivateKey privateKey) {
        super.setPrivateKey(privateKey);
        this.privateKeyParams = BCUtil.toParams(privateKey);
        return this;
    }

    public SM2 setPrivateKeyParams(ECPrivateKeyParameters privateKeyParams) {
        this.privateKeyParams = privateKeyParams;
        return this;
    }

    @Override
    public SM2 setPublicKey(PublicKey publicKey) {
        super.setPublicKey(publicKey);
        this.publicKeyParams = BCUtil.toParams(publicKey);
        return this;
    }

    public SM2 setPublicKeyParams(ECPublicKeyParameters publicKeyParams) {
        this.publicKeyParams = publicKeyParams;
        return this;
    }

    public SM2 usePlainEncoding() {
        return null;
    }

    public SM2 setDigest(Digest digest) {
        this.engine = null;
        this.signer = null;
        return this;
    }

    private CipherParameters getCipherParameters(KeyType keyType) {
        switch (keyType) {
            case PublicKey: {
                Assert.notNull(this.publicKeyParams, "PublicKey must be not null !", new Object[0]);
                return this.publicKeyParams;
            }
            case PrivateKey: {
                Assert.notNull(this.privateKeyParams, "PrivateKey must be not null !", new Object[0]);
                return this.privateKeyParams;
            }
        }
        return null;
    }

    private SM2Engine getEngine() {
        return null;
    }
}

