/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.kafka.process;

import com.alibaba.fastjson.JSONObject;
import com.manatee.common.domain.ResultCode;
import com.manatee.common.exception.BizException;
import com.manatee.common.util.NumberUtils;
import com.manatee.common.util.StringUtil;
import com.manatee.lowcode.iutil.IInputUtil;
import com.manatee.lowcode.util.ProcessConfUtil;
import com.manatee.lowcode.util.VariableUtil;
import com.manatee.process.IProcess;
import com.manatee.process.domain.ProcessContent;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.kafka.support.SendResult;
import org.springframework.stereotype.Service;
import org.springframework.util.concurrent.ListenableFutureCallback;

@Service
public class KafkaProducerProcess
implements IProcess {
    private Logger log = LoggerFactory.getLogger(KafkaProducerProcess.class);
    @Resource
    private ProcessConfUtil processConfUtil;
    @Resource
    private VariableUtil variableUtil;
    @Resource
    private IInputUtil inputUtil;
    @Resource
    private KafkaTemplate<String, Object> kafkaTemplate;

    public void process(ProcessContent content) throws BizException {
        String partitionStr;
        this.processConfUtil.checkConf(content, new String[]{"topic"});
        String topic = this.variableUtil.calVarInConf(content, "topic");
        String key = this.variableUtil.calVarInConf(content, "key");
        String uniqueid = this.variableUtil.calVarInConf(content, "uniqueid");
        Map value = this.inputUtil.getHandleObject(content, "value");
        JSONObject valueJson = new JSONObject(true);
        valueJson.putAll(value);
        if (StringUtil.isNotBlank((String)uniqueid)) {
            valueJson.put("_uniqueid", (Object)uniqueid);
        }
        if ((partitionStr = this.variableUtil.calVarInConf(content, "partition")) != null && !NumberUtils.isNumber((String)partitionStr)) {
            throw new BizException(ResultCode.PARAM_IS_ERROR, "partition must be number");
        }
        Integer partition = partitionStr == null ? null : Integer.valueOf(partitionStr);
        this.kafkaTemplate.send(topic, partition, (Object)key, (Object)valueJson.toJSONString()).addCallback((ListenableFutureCallback)new ListenableFutureCallback<SendResult<String, Object>>(){

            public void onFailure(Throwable ex) {
                KafkaProducerProcess.this.log.warn("kafka producer fail: " + ex.getMessage());
            }

            public void onSuccess(SendResult<String, Object> result) {
                KafkaProducerProcess.this.log.warn("kafka producer success,topic\u540d\u79f0\uff1a" + result.getRecordMetadata().topic() + ",\u5206\u533a\uff1a" + result.getRecordMetadata().partition() + "\uff0c\u6d88\u606f\u5728\u5206\u533a\u4e2d\u7684\u6807\u8bc6\uff1a" + result.getRecordMetadata().offset());
            }
        });
    }

    public String getName() {
        return "kafkaProducer";
    }
}

