#!/bin/bash

traverse_directory() {
  local directory="$1"
  local setting_path="$2"

  for file in "$directory"/*; do
    if [[ -f "$file" && "$file" == *.jar ]]; then
      IFS='/'
      read -ra parts <<< "$file"
      length=${#parts[@]}
      file_Name_withOut_suffix="${file%????}"
      if [ -z "$setting_path" ]; then
        mvn install:install-file -Dfile="$file" -DgroupId=com.manatee.manatee-lowcode -DartifactId="${parts[length-3]}" -Dversion="${parts[length-2]}" -Dpackaging=jar -DpomFile="$file_Name_withOut_suffix"".pom"
      else 
        mvn install:install-file -s "$setting_path" -Dfile="$file" -DgroupId=com.manatee.manatee-lowcode -DartifactId="${parts[length-3]}" -Dversion="${parts[length-2]}" -Dpackaging=jar 
      fi
    
    elif [[ -d "$file" ]]; then
      traverse_directory "$file" "$setting_path"
    fi
  done
}


traverse_pom_directory() {
  local directory="$1"
  local setting_path="$2"

  for file in "$directory"/*; do
    if [[ -f "$file" && "$file" == *.pom ]]; then
      IFS='/'
      read -ra parts <<< "$file"
      length=${#parts[@]}

      if [ -z "$setting_path" ]; then
        mvn install:install-file -Dfile="$file" -DgroupId=com.manatee.lowcode -DartifactId="${parts[length-3]}" -Dversion="${parts[length-2]}" -Dpackaging=pom
      else 
        mvn install:install-file -s "$setting_path" -Dfile="$file" -DgroupId=com.manatee.lowcode -DartifactId="${parts[length-3]}" -Dversion="${parts[length-2]}" -Dpackaging=pom
      fi
    elif [[ -d "$file" ]]; then
      traverse_pom_directory "$file" "$setting_path"
    fi
  done
}

current_directory=$(pwd)/manatee-lowcode

current_pom_directory=$(pwd)/lowcode

echo "请输入 setting 文件目录（可回车键跳过使用maven默认配置文件）："
read setting_path;

echo "$setting_path"

traverse_directory "$current_directory" "$setting_path"
traverse_pom_directory "$current_pom_directory" "$setting_path"