CREATE TABLE `lowcode_logic_base` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `project_id` bigint(20) NOT NULL COMMENT '项目id',
  `logic_type` tinyint(4) NOT NULL DEFAULT '1' COMMENT '模型类型，1-普通模型，2-interface，3-impl',
  `logic_name` varchar(32) NOT NULL COMMENT '名称',
  `logic_code` varchar(64) NOT NULL COMMENT '编码',
  `logic_pingyin` varchar(255) NOT NULL COMMENT '名称拼音',
  `description` varchar(255) DEFAULT NULL COMMENT '描述',
  `physical_datasource` varchar(128) DEFAULT NULL COMMENT '物理表数据源',
  `physical_id` bigint(20) DEFAULT NULL COMMENT '物理模型id',
  `physical_table` varchar(128) DEFAULT NULL COMMENT '物理模型数据库表',
  `convert_ptl_module_id` bigint(20) DEFAULT NULL COMMENT '物理转逻辑moduleId',
  `convert_ptl_state` tinyint(4) DEFAULT '0' COMMENT '物理转逻辑状态,0-默认，1-自定义',
  `convert_ltp_module_id` bigint(20) DEFAULT NULL COMMENT '逻辑转物理moduleId',
  `convert_ltp_state` tinyint(4) DEFAULT '0' COMMENT '逻辑转物理状态,0-默认，1-自定义',
  `create_user` bigint(20) DEFAULT NULL COMMENT '创建人',
  `gmt_create` datetime DEFAULT NULL COMMENT '创建时间',
  `modified_user` bigint(20) DEFAULT NULL COMMENT '修改用户',
  `gmt_modified` datetime DEFAULT NULL COMMENT '修改时间',
  `valid` tinyint(4) DEFAULT 0 COMMENT '状态:-1 删除, 0 正常',
  `logic_conf` text NULL COMMENT '模型配置',
  `logic_version` varchar(32) NULL DEFAULT '1' COMMENT '版本号',
  `sub_logic_type` tinyint(4) NULL COMMENT '模型子类型，11-数据表，12-方法',
  PRIMARY KEY (`id`),
  KEY `idx_projectId_code` (`project_id`,`logic_code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='数据模型-逻辑模型基础表';