/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.lowcode.generation.domain;

import com.alibaba.fastjson.JSONObject;
import com.manatee.common.util.tool.core.builder.Builder;
import com.manatee.common.util.tool.core.util.ClassUtil;
import com.manatee.lowcode.generation.entity.ModuleDTO;
import com.manatee.lowcode.generation.entity.PackageDTO;
import com.manatee.process.domain.ProcessContent;
import freemarker.cache.ClassTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenerationProcessContentBuilder
extends ProcessContent
implements Builder<String> {
    private Logger LOGGER = LoggerFactory.getLogger(GenerationProcessContentBuilder.class);
    private final LinkedList<StringBuilder> codeBuilder = new LinkedList();
    private Set<String> paramsNames = new HashSet<String>();
    private final Set<String> importSet = new HashSet<String>();
    private final Set<String> resourceSet = new HashSet<String>();
    private final Set<String> privateFunName = new HashSet<String>();
    private final List<String> privateFuns = new ArrayList<String>();
    private String packagePath;
    private String className;
    private final LinkedList<String> funName = new LinkedList();
    private int indentationNum = 2;
    private String indentationStr = "        ";
    private StringBuilder preStr = new StringBuilder();
    private StringBuilder afterStr = new StringBuilder();
    private String toPath;
    private Map<String, ModuleDTO> moduleCodeMap;
    private Map<Long, PackageDTO> packageIdMap;
    private Long packageId;

    public String build() {
        Map map = this.toMap();
        this.generateByTemplate(map, "service.ftl", this.toPath);
        return this.preStr.append(this.codeBuilder).append((CharSequence)this.afterStr).toString();
    }

    public String getToPath() {
        return this.toPath;
    }

    public void setParamsNames(Set<String> paramsNames) {
        this.paramsNames = paramsNames;
    }

    public void setToPath(String toPath) {
        this.toPath = toPath;
    }

    public StringBuilder getCurrentCodeBuilder() {
        return this.codeBuilder.getLast();
    }

    public LinkedList<StringBuilder> getCodeBuilder() {
        return this.codeBuilder;
    }

    public Set<String> getImportSet() {
        return this.importSet;
    }

    public Set<String> getResourceSet() {
        return this.resourceSet;
    }

    public String getPackagePath() {
        return this.packagePath;
    }

    public GenerationProcessContentBuilder setPackagePath(String packagePath) {
        this.packagePath = packagePath;
        return this;
    }

    public String getClassName() {
        return this.className;
    }

    public GenerationProcessContentBuilder setClassName(String className) {
        this.className = className;
        return this;
    }

    public String getCurrentFunName() {
        if (this.funName.size() <= 0) {
            return null;
        }
        return this.funName.getLast();
    }

    public LinkedList<String> getFunName() {
        return this.funName;
    }

    public GenerationProcessContentBuilder setCurrentFunName(String funName) {
        this.funName.addLast(funName);
        return this;
    }

    public StringBuilder getPreStr() {
        return this.preStr;
    }

    public GenerationProcessContentBuilder setPreStr(StringBuilder preStr) {
        this.preStr.append((CharSequence)preStr);
        return this;
    }

    public StringBuilder getAfterStr() {
        return this.afterStr;
    }

    public GenerationProcessContentBuilder setAfterStr(StringBuilder afterStr) {
        this.afterStr.insert(0, afterStr);
        return this;
    }

    public void addImportSet(String improt) {
        this.importSet.add(improt);
    }

    public void addResourceSet(String resource) {
        this.resourceSet.add(resource);
    }

    public int getIndentationNum() {
        return this.indentationNum;
    }

    public void setIndentationNum(int indentationNum) {
        this.indentationNum = indentationNum;
    }

    public String getIndentationStr() {
        return this.indentationStr;
    }

    public void setIndentationStr(String indentationStr) {
        this.indentationStr = indentationStr;
    }

    public Set<String> getPrivateFunName() {
        return this.privateFunName;
    }

    public List<String> getPrivateFuns() {
        return this.privateFuns;
    }

    public String addIndentationStr() {
        this.indentationStr = this.indentationStr + "    ";
        ++this.indentationNum;
        return this.indentationStr;
    }

    public Set<String> getParamsNames() {
        return this.paramsNames;
    }

    public void setModuleCodeMap(Map<String, ModuleDTO> moduleCodeMap) {
        this.moduleCodeMap = moduleCodeMap;
    }

    public void setPackageIdMap(Map<Long, PackageDTO> packageIdMap) {
        this.packageIdMap = packageIdMap;
    }

    public void setPackageId(Long packageId) {
        this.packageId = packageId;
    }

    public String creatParamsName(StringBuilder paramsName) {
        int i = 1;
        while (this.paramsNames.contains(paramsName.toString())) {
            paramsName = paramsName.append(i);
            ++i;
        }
        this.paramsNames.add(paramsName.toString());
        return paramsName.toString();
    }

    public Map toMap() {
        return (JSONObject)JSONObject.toJSON((Object)((Object)this));
    }

    public String generateByTemplate(Map<String, Object> objectMap, String templateName, String toPath) {
        try {
            File toFile = new File(toPath);
            if (!toFile.exists()) {
                toFile.createNewFile();
            }
            FileOutputStream fileOutputStream = new FileOutputStream(toFile);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, Charset.forName("UTF-8").name());
            GenerationProcessContentBuilder.generateToStream(objectMap, templateName, outputStreamWriter);
            fileOutputStream.close();
            this.LOGGER.info("\u6587\u4ef6\u3010{}\u3011\u521b\u5efa\u6210\u529f", (Object)toPath);
            return toFile.getPath();
        }
        catch (Exception e) {
            this.LOGGER.error("generateByTemplate error, templateName:\u3010{}\u3011, toPath:\u3010{}\u3011,objectMap:\u3010{}\u3011,e:{]", new Object[]{templateName, toPath, objectMap, e});
            return null;
        }
    }

    public static void generateToStream(Map<String, Object> objectMap, String templateName, Writer out) throws IOException, TemplateException {
        Configuration configuration = new Configuration(Configuration.VERSION_2_3_23);
        configuration.setTemplateLoader((TemplateLoader)new ClassTemplateLoader(ClassUtil.getClassLoader(), "/template"));
        configuration.setNumberFormat("#");
        Template template = configuration.getTemplate(templateName);
        template.process(objectMap, out);
    }

    public void addCode(StringBuilder stringBuilder) {
        this.codeBuilder.addLast(stringBuilder);
    }

    public Map<String, ModuleDTO> getModuleCodeMap() {
        return this.moduleCodeMap;
    }

    public Map<Long, PackageDTO> getPackageIdMap() {
        return this.packageIdMap;
    }

    public Long getPackageId() {
        return this.packageId;
    }
}

