/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.oracle.handle;

import com.alibaba.fastjson.JSONObject;
import com.manatee.common.domain.DBInsert;
import com.manatee.common.domain.DBQuery;
import com.manatee.common.domain.Page;
import com.manatee.common.domain.StrSplit;
import com.manatee.common.exception.BizException;
import com.manatee.common.util.StringUtil;
import com.manatee.lowcode.iutil.IOutputUtil;
import com.manatee.lowcodedb.handle.DBHandle;
import com.manatee.lowcodedb.newdb.meta.MetaUtil;
import com.manatee.process.domain.ProcessContent;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="oracle")
public class OracleDBHandle
extends DBHandle {
    private static final Logger log = LoggerFactory.getLogger(OracleDBHandle.class);

    public String getName() {
        return "oracle";
    }

    public PreparedStatement getPreparedStatement(Connection con, StringBuilder sqlSB) throws SQLException {
        return con.prepareStatement(sqlSB.toString(), 1);
    }

    public StringBuilder initPageSql(StringBuilder sqlSB, DBQuery dbQuery) {
        Page page = dbQuery.getPage();
        if (page == null) {
            return sqlSB;
        }
        Integer pageNum = page.getPageNum();
        Integer pageSize = page.getPageSize();
        Integer skip = null;
        if (pageNum != null && pageSize != null) {
            skip = (pageNum - 1) * pageSize;
        }
        String originSql = sqlSB.toString();
        sqlSB = new StringBuilder();
        sqlSB.append("SELECT * FROM (SELECT temp.*, ROWNUM RN FROM (").append(originSql).append(") temp WHERE ROWNUM <= " + (skip + pageSize) + ") WHERE RN >= " + (skip + 1) + " ");
        return sqlSB;
    }

    public StringBuilder initInsertConditionSql(DBInsert insert, Connection con) throws SQLException {
        String insertType = insert.getInsertType();
        StringBuilder paramSb = new StringBuilder();
        StringBuilder sqlSb = new StringBuilder();
        if (StringUtils.isBlank((String)insertType) || "error".equalsIgnoreCase(insertType)) {
            sqlSb.append("insert");
            paramSb.append(" into ");
        } else if ("ignore".equalsIgnoreCase(insertType)) {
            sqlSb.append("insert");
            paramSb.append(" ignore into ");
        } else if ("replace".equalsIgnoreCase(insertType)) {
            paramSb.append(" replace into ");
        }
        paramSb.append(insert.getTable());
        paramSb.append(" (");
        Map insertColumns = insert.getInsertColumns();
        if (insertColumns == null) {
            List list = insert.getInsertColumnsBatch();
            insertColumns = (Map)list.get(0);
        }
        StringBuilder valueSb = new StringBuilder();
        for (Map.Entry aMap : insertColumns.entrySet()) {
            Object value;
            if (!insert.isBatch() && (value = aMap.getValue()) == null) continue;
            paramSb.append((String)aMap.getKey()).append(StrSplit.D);
            valueSb.append("?,");
        }
        String params = paramSb.substring(0, paramSb.length() - 1);
        String value = valueSb.substring(0, valueSb.length() - 1);
        StringBuilder paramAndValueSb = new StringBuilder(params);
        paramAndValueSb = paramAndValueSb.append(") values ");
        valueSb = new StringBuilder();
        valueSb.append((CharSequence)paramAndValueSb).append("(").append(value).append(") ");
        if (insert.isBatch()) {
            String valuesSql = valueSb.toString();
            List insertBatchColumns = insert.getInsertColumnsBatch();
            for (int i = 1; i < insertBatchColumns.size(); ++i) {
                valueSb = valueSb.append(valuesSql);
            }
        }
        sqlSb = sqlSb.append(" all ").append((CharSequence)valueSb).append(" SELECT 1 FROM DUAL ");
        return sqlSb;
    }

    public StringBuilder initSelectOneLimitSql(StringBuilder sqlSB, DBQuery dbQuery) {
        return sqlSB;
    }

    public void handleInsertResult(DBInsert insert, Connection con, PreparedStatement ps, JSONObject result, int insertNum) {
        result.put("count", (Object)insertNum);
    }

    public void composeInsertResult(DBInsert insert, ProcessContent content, JSONObject insertResult, IOutputUtil outputUtil) throws BizException {
        outputUtil.setDefaultReturnKey(content, "count");
        outputUtil.putData(content, insertResult.get((Object)"count"));
        if (insert.isBatch()) {
            outputUtil.setDefaultReturnKey(content, "count");
            outputUtil.putData(content, insertResult.get((Object)"count"));
        } else {
            String pkName = insertResult.getString("pkName");
            if (StringUtil.isNotBlank((String)pkName)) {
                outputUtil.setDefaultReturnKey(content, insert.getPkName());
                outputUtil.putData(content, (Object)pkName);
            } else {
                outputUtil.setDefaultReturnKey(content, "count");
                outputUtil.putData(content, insertResult.get((Object)"count"));
            }
        }
    }

    public StringBuilder initSchemaSql(Connection con, StringBuilder sqlSb, String schema) {
        sqlSb.append("SELECT USERNAME AS TABLE_SCHEMA FROM DBA_USERS WHERE 1 = 1 ");
        if (StringUtil.isNotBlank((String)schema)) {
            sqlSb.append("AND USERNAME LIKE ").append("'%").append(schema).append("%'");
        }
        return sqlSb;
    }

    public StringBuilder initTablesSql(Connection con, StringBuilder sqlSb, String table, String schema) {
        if (StringUtil.isNotBlank((String)schema)) {
            sqlSb.append("SELECT a.TABLE_NAME, b.COLUMN_NAME FROM (SELECT * FROM (SELECT dtc.TABLE_NAME FROM dba_tab_columns dtc ");
            sqlSb.append("join dba_tables dt on dt.table_name = dtc.table_name where dt.owner = '").append(schema).append("' ");
            sqlSb.append("GROUP BY dtc.TABLE_NAME) WHERE ROWNUM <= 10 ");
            if (StringUtil.isNotBlank((String)table)) {
                sqlSb.append("AND TABLE_NAME LIKE ").append("'%").append(table).append("%'");
            }
            sqlSb.append(") a JOIN (SELECT TABLE_NAME,COLUMN_NAME,COLUMN_ID FROM dba_tab_columns) b ON a.TABLE_NAME = b.TABLE_NAME ");
            sqlSb.append("ORDER BY b.COLUMN_ID");
        } else {
            sqlSb.append("SELECT a.TABLE_NAME, b.COLUMN_NAME FROM (SELECT * FROM (SELECT utc.TABLE_NAME FROM user_tab_columns utc ");
            sqlSb.append("GROUP BY utc.TABLE_NAME) WHERE ROWNUM <= 10 ");
            if (StringUtil.isNotBlank((String)table)) {
                sqlSb.append("AND TABLE_NAME LIKE ").append("'%").append(table).append("%'");
            }
            sqlSb.append(") a JOIN (SELECT TABLE_NAME,COLUMN_NAME,COLUMN_ID FROM user_tab_columns) b ON a.TABLE_NAME = b.TABLE_NAME ");
            sqlSb.append("ORDER BY b.COLUMN_ID");
        }
        return sqlSb;
    }

    public int executeInsert(PreparedStatement ps, DBInsert insert) throws SQLException {
        return ps.executeUpdate(insert.getExecuteSql());
    }

    public void initCountSql(String from, DBQuery dbQueryForCount) {
        from = from.trim();
        dbQueryForCount.setSql("select count(*) as \"count(*)\" from (" + from + ") count_table");
    }

    public List<String> getSchemas(Connection conn) {
        return MetaUtil.getSchemas((Connection)conn);
    }

    public List<String> getTablesBySchema(Connection conn, String schema, String tableName) throws SQLException {
        if (StringUtil.isBlank((String)schema)) {
            schema = conn.getSchema();
        }
        return MetaUtil.getTablesBySchema((Connection)conn, null, (String)schema, (String)tableName);
    }

    public List<String> getColumnNamesBySchemaAndTable(Connection conn, String schema, String tableName) {
        return MetaUtil.getColumnNamesBySchemaAndTable((Connection)conn, null, (String)schema, (String)tableName);
    }
}

