/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.common.util.tool.core.lang.tree;

import com.manatee.common.util.tool.core.lang.Assert;
import com.manatee.common.util.tool.core.lang.tree.Node;
import com.manatee.common.util.tool.core.lang.tree.TreeNodeConfig;
import com.manatee.common.util.tool.core.lang.tree.TreeUtil;
import com.manatee.common.util.tool.core.util.ObjectUtil;
import java.util.LinkedHashMap;
import java.util.List;

public class Tree<T>
extends LinkedHashMap<String, Object>
implements Node<T> {
    private static final long serialVersionUID = 1L;
    private final TreeNodeConfig treeNodeConfig;
    private Tree<T> parent;

    public Tree() {
        this((TreeNodeConfig)null);
    }

    public Tree(TreeNodeConfig treeNodeConfig) {
        this.treeNodeConfig = ObjectUtil.defaultIfNull(treeNodeConfig, TreeNodeConfig.DEFAULT_CONFIG);
    }

    public Tree<T> getParent() {
        return this.parent;
    }

    public Tree<T> getNode(T id) {
        return TreeUtil.getNode(this, id);
    }

    public List<CharSequence> getParentsName(T id, boolean includeCurrentNode) {
        return TreeUtil.getParentsName(this.getNode(id), includeCurrentNode);
    }

    public List<CharSequence> getParentsName(boolean includeCurrentNode) {
        return TreeUtil.getParentsName(this, includeCurrentNode);
    }

    public Tree<T> setParent(Tree<T> parent) {
        this.parent = parent;
        if (null != parent) {
            this.setParentId((Object)parent.getId());
        }
        return this;
    }

    @Override
    public T getId() {
        return (T)this.get(this.treeNodeConfig.getIdKey());
    }

    @Override
    public Tree<T> setId(T id) {
        this.put(this.treeNodeConfig.getIdKey(), id);
        return this;
    }

    @Override
    public T getParentId() {
        return (T)this.get(this.treeNodeConfig.getParentIdKey());
    }

    @Override
    public Tree<T> setParentId(T parentId) {
        this.put(this.treeNodeConfig.getParentIdKey(), parentId);
        return this;
    }

    @Override
    public CharSequence getName() {
        return (CharSequence)this.get(this.treeNodeConfig.getNameKey());
    }

    @Override
    public Tree<T> setName(CharSequence name) {
        this.put(this.treeNodeConfig.getNameKey(), name);
        return this;
    }

    @Override
    public Comparable<?> getWeight() {
        return (Comparable)this.get(this.treeNodeConfig.getWeightKey());
    }

    @Override
    public Tree<T> setWeight(Comparable<?> weight) {
        this.put(this.treeNodeConfig.getWeightKey(), weight);
        return this;
    }

    public List<Tree<T>> getChildren() {
        return (List)this.get(this.treeNodeConfig.getChildrenKey());
    }

    public void setChildren(List<Tree<T>> children) {
        this.put(this.treeNodeConfig.getChildrenKey(), children);
    }

    public void putExtra(String key, Object value) {
        Assert.notEmpty(key, "Key must be not empty !", new Object[0]);
        this.put(key, value);
    }
}

