/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.var.manager;

import com.manatee.process.domain.ProcessContent;
import com.manatee.var.IVar;
import com.manatee.var.VarUtil;
import com.manatee.var.util.StrUtil;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class VarManager {
    @Resource
    private VarUtil varUtil;
    private String[] keys = new String[]{"subSource", "source", "projectId", "userId"};

    public String varsReplace(ProcessContent content, String exp) {
        if (!VarManager.isHaveVar(exp)) {
            return exp;
        }
        this.initKeywords(content);
        String result = exp;
        List<String> vars = VarManager.getVars(exp);
        for (String var : vars) {
            String aValue = this.getVarValue(content, var);
            result = VarManager.replaceAVar(result, var, aValue);
        }
        return result;
    }

    private void initKeywords(ProcessContent content) {
        Map temp = (Map)content.getValue("tempContext");
        if (temp == null) {
            return;
        }
        for (String key : this.keys) {
            Object tempValue;
            Object haveValue = content.getValue(key);
            if (haveValue != null || (tempValue = temp.get(key)) == null) continue;
            content.putTempContent(key, tempValue);
        }
    }

    private String getVarValue(ProcessContent content, String var) {
        IVar varBean;
        Object aValue = content.getValue(var);
        if (aValue == null && (varBean = this.varUtil.getVar(var)) != null) {
            aValue = varBean.getVar(content);
        }
        String result = null;
        result = aValue == null ? "" : aValue + "";
        return result;
    }

    public static boolean isHaveVar(String content) {
        if (content == null) {
            return false;
        }
        return content.indexOf("${") != -1 || content.indexOf("$##DKH##") != -1 || content.indexOf("##VARS##") != -1;
    }

    public static boolean isHaveRepVar(String content) {
        if (content == null) {
            return false;
        }
        return content.indexOf("##VAR##") != -1;
    }

    protected static List<String> getVars(String content) {
        List<String> list = StrUtil.getMidStr(content, "\\$\\{", "\\}");
        if (list.size() > 0) {
            return list;
        }
        if (content.indexOf("$##DKH##") != -1) {
            list = StrUtil.getMidStr(content, "\\$##DKH##", "##YDKH##");
        }
        if (content.indexOf("##VAR##") != -1) {
            list = StrUtil.getMidStr(content, "##VAR##", "##VARS##");
        }
        return list;
    }

    protected static String replaceAVar(String content, String key, String replaceValue) {
        StringBuilder sb = new StringBuilder("${").append(key).append("}");
        String variable = sb.toString();
        if (content.indexOf(variable) != -1) {
            content = content.replace(variable, replaceValue);
        }
        if (content.indexOf("$##DKH##") != -1) {
            sb = new StringBuilder("$##DKH##").append(key).append("##YDKH##");
            variable = sb.toString();
            content = content.replace(variable, replaceValue);
        }
        if (content.indexOf("##VAR##") != -1) {
            sb = new StringBuilder("##VAR##").append(key).append("##VARS##");
            variable = sb.toString();
            content = content.replace(variable, replaceValue);
        }
        return content;
    }

    public static void main(String[] args) {
        String content = "fcst:${productId}";
        List<String> list = VarManager.getVars(content);
        if (VarManager.isHaveVar(content)) {
            System.out.println("have");
            content = VarManager.replaceAVar(content, "orderTitle", "aaaa");
            System.out.println(content);
        }
    }

    public void setVarUtil(VarUtil varUtil) {
        this.varUtil = varUtil;
    }
}

