/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.lowcode.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.manatee.common.domain.StrSplit;
import com.manatee.common.util.StringUtil;
import com.manatee.lowcode.util.VariableUtil;
import com.manatee.process.domain.ProcessContent;
import com.manatee.process.domain.Step;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections.map.HashedMap;
import org.springframework.stereotype.Service;

@Service
public class ProcessDataUtil {
    @Resource
    private VariableUtil variableUtil;

    public Object getData(ProcessContent content) {
        return this.getData(content, null);
    }

    public Object getData(ProcessContent content, String key) {
        if (StringUtil.isBlank((String)key)) {
            key = this.getVarKey(content, "input");
        }
        if (this.singleKey(key)) {
            return this.getAData(content, key);
        }
        HashedMap value = new HashedMap();
        String[] keys = key.split(StrSplit.D);
        for (int i = 0; i < keys.length; ++i) {
            String aKey = keys[i].trim();
            Object aValue = this.getAData(content, aKey);
            if (aValue == null) continue;
            if (aValue instanceof Map) {
                value.putAll((Map)aValue);
                continue;
            }
            value.put(aKey, aValue);
        }
        return value;
    }

    private boolean singleKey(String key) {
        if (StringUtil.isBlank((String)key)) {
            return true;
        }
        return key.indexOf(StrSplit.D) == -1;
    }

    private Object getAData(ProcessContent content, String key) {
        JSONObject conf = content.getStepConf();
        String requestStr = "request.";
        String responseStr = "response.";
        if (key != null && key.indexOf(requestStr) != -1) {
            String newKey = key.replace(requestStr, "");
            return content.getRequestSubValue(newKey);
        }
        if (key != null && key.indexOf(responseStr) != -1) {
            String newKey = key.replace(responseStr, "");
            return content.getResponseSubValue(newKey);
        }
        return ProcessDataUtil.getDefaultData(content, conf, key);
    }

    private static Object getDefaultData(ProcessContent content, JSONObject conf, String key) {
        String valueFrom = conf.getString("valueFrom");
        if ("request".equals(valueFrom)) {
            return content.getRequestSubValue(key);
        }
        if ("response".equals(valueFrom)) {
            return content.getResponseSubValue(key);
        }
        Object value = content.getRequestSubValue(key);
        if (value == null) {
            value = content.getResponseSubValue(key);
        }
        return value;
    }

    public List<Map<String, Object>> getList(ProcessContent content) {
        return this.getList(content, null);
    }

    public List<Map<String, Object>> getList(ProcessContent content, String key) {
        JSONObject conf = content.getStepConf();
        if (StringUtil.isBlank((String)key)) {
            key = this.getVarKey(content, "input");
        }
        if (StringUtil.isBlank((String)key)) {
            String listTempKey = ProcessDataUtil.getObjTempKey(content);
            if (StringUtil.isNotBlank((String)listTempKey)) {
                Object value = ProcessDataUtil.getDefaultData(content, conf, listTempKey);
                return this.value2MapList(value);
            }
            key = this.getVarKey(content, "input");
            if (StringUtil.isBlank((String)key)) {
                key = "listData";
            }
        }
        String requestStr = "request.";
        String responseStr = "response.";
        if (key.indexOf(requestStr) != -1) {
            String newKey = key.replace(requestStr, "");
            Object value = content.getRequestSubValue(newKey);
            return this.value2MapList(value);
        }
        if (key.indexOf(responseStr) != -1) {
            String newKey = key.replace(responseStr, "");
            Object value = content.getResponseSubValue(newKey);
            return this.value2MapList(value);
        }
        Object value = ProcessDataUtil.getDefaultData(content, conf, key);
        return this.value2MapList(value);
    }

    private List<Map<String, Object>> value2MapList(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof JSONArray) {
            return this.array2MapList((JSONArray)value);
        }
        return (List)value;
    }

    private List<Map<String, Object>> array2MapList(JSONArray value) {
        ArrayList<Map<String, Object>> paramList = new ArrayList<Map<String, Object>>();
        JSONArray array = value;
        for (int i = 0; i < array.size(); ++i) {
            JSONObject obj = array.getJSONObject(i);
            paramList.add((Map<String, Object>)obj);
        }
        return paramList;
    }

    public void putData(ProcessContent content, String key, Object value) {
        JSONObject conf = content.getStepConf();
        key = this.getDefaultPutKey(content, key, value);
        String valueTo = conf.getString("valueTo");
        if (value instanceof Map && "outputUnfold".equals(key)) {
            ProcessDataUtil.putData(content, (Map)value);
            return;
        }
        if ("request".equals(valueTo)) {
            ProcessDataUtil.putObjTempKey(content, key, value);
            content.putRequestSubValue(key, value);
        } else {
            ProcessDataUtil.putObjTempKey(content, key, value);
            content.putResponseSubValue(key, value);
        }
    }

    public static void putData(ProcessContent content, Map value) {
        JSONObject conf = content.getStepConf();
        String valueTo = conf.getString("valueTo");
        if ("request".equals(valueTo)) {
            content.putRequest(value);
        } else {
            content.putResponse(value);
        }
    }

    private String getDefaultPutKey(ProcessContent content, String key, Object value) {
        if (StringUtil.isNotBlank((String)key)) {
            return key;
        }
        key = this.getVarKey(content, "output");
        if (StringUtil.isBlank((String)key)) {
            key = "outputData";
        }
        return key;
    }

    public String getVarKey(ProcessContent content, String confKey) {
        return this.variableUtil.calVarInConf(content, confKey);
    }

    private static String getObjTempKey(ProcessContent content) {
        String key = (String)content.getTempContent("listTempContext");
        if (StringUtil.isBlank((String)key)) {
            key = (String)content.getTempContent("objectTempContext");
        }
        return key;
    }

    private static void putObjTempKey(ProcessContent content, String key, Object value) {
        if (value instanceof List) {
            content.putTempContent("listTempContext", (Object)key);
        }
        if (value instanceof JSONObject) {
            content.putTempContent("objectTempContext", (Object)key);
        }
    }

    public static void main(String[] args) {
        Step step = new Step();
        Integer a2 = 1;
        String c = "wo de ";
        Object b = JSONObject.toJSON((Object)step);
        System.out.println(b.toString());
    }
}

