/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.redis.source;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.parser.Feature;
import com.manatee.common.domain.ResultCode;
import com.manatee.common.exception.BizException;
import com.manatee.redis.domain.DtFuzzyQuery;
import com.manatee.redis.domain.DtHashDO;
import com.manatee.redis.domain.DtQuery;
import com.manatee.redis.domain.DtTopQuery;
import com.manatee.redis.source.IDtSource;
import com.manatee.redis.util.RedisSentinelReadUtil;
import com.manatee.redis.util.RedisSentinelWriteUtil;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="redisSentinelDtSource")
public class RedisSentinelDtSourceImpl
implements IDtSource {
    @Value(value="${spring.redis.keyPrefix:}")
    private String keyPrefix;
    @Resource
    private RedisSentinelReadUtil redisSentinelReadUtil;
    @Resource
    private RedisSentinelWriteUtil redisSentinelWriteUtil;
    private Logger log = LoggerFactory.getLogger(RedisSentinelDtSourceImpl.class);

    @Override
    public Map<String, Object> query(DtQuery dtQuery) throws BizException {
        List<String> fieldList = dtQuery.getHashKeys();
        String[] fields = fieldList.toArray(new String[fieldList.size()]);
        String key = this.getKey(dtQuery);
        key = this.addKeyPrefix(key);
        if (this.isAllKey(fields)) {
            return this.queryAll(dtQuery, key);
        }
        return this.redisSentinelReadUtil.hmgetValue(dtQuery.getDbIndex(), key, fields);
    }

    @Override
    public long queryTtl(DtQuery dtQuery) throws BizException {
        String key = this.getKey(dtQuery);
        key = this.addKeyPrefix(key);
        return this.redisSentinelReadUtil.getTtl(dtQuery.getDbIndex(), key);
    }

    private Map<String, Object> queryAll(DtQuery dtQuery, String key) {
        key = this.addKeyPrefix(key);
        Map<String, String> map = this.redisSentinelReadUtil.hmgetAll(dtQuery.getDbIndex(), key);
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, String> maps : map.entrySet()) {
            result.put(maps.getKey(), maps.getValue());
        }
        return result;
    }

    @Override
    public Long incr(DtQuery dtQuery) {
        String key = dtQuery.getKey();
        key = this.addKeyPrefix(key);
        return this.redisSentinelWriteUtil.incr(dtQuery.getDbIndex(), key);
    }

    @Override
    public List<String> queryMembers(DtQuery dtQuery) {
        String key = dtQuery.getKey();
        key = this.addKeyPrefix(key);
        Set<String> set = this.redisSentinelReadUtil.smembers(dtQuery.getDbIndex(), key);
        ArrayList<String> list = new ArrayList<String>(set);
        return list;
    }

    private boolean isAllKey(String[] fields) {
        if (fields.length != 1) {
            return false;
        }
        String field = fields[0];
        return "*".equals(field);
    }

    private String getKey(DtQuery dtQuery) throws BizException {
        List<String> keys = dtQuery.getKeys();
        if (keys == null || keys.size() == 0) {
            throw new BizException(ResultCode.BIZ_ERROR, "query_key_is_null");
        }
        return keys.get(0);
    }

    @Override
    public List<Map<String, Object>> batchQuery(DtQuery dtQuery) {
        List<String> hashList = dtQuery.getHashKeys();
        String[] fields = new String[hashList.size()];
        hashList.toArray(fields);
        List<String> keys = dtQuery.getKeys();
        ArrayList<String> keysNew = new ArrayList<String>();
        if (keys != null) {
            for (String key : keys) {
                key = this.addKeyPrefix(key);
                keysNew.add(key);
            }
        }
        int db = dtQuery.getDbIndex();
        ArrayList<Map<String, Object>> result = new ArrayList();
        try {
            result = this.redisSentinelReadUtil.hmgetBatchValue(db, keysNew, fields);
        }
        catch (Exception e) {
            this.log.error("[RedisDtSourceImpl.batchQuery]_exception", (Throwable)e);
        }
        return result;
    }

    @Override
    public JSONArray batchQueryValue(DtQuery dtQuery) {
        List<String> keylist = dtQuery.getKeys();
        if (keylist == null) {
            this.log.error("[RedisDtSourceImpl.batchQueryValue]_biz_error,dtQuery:{},msg:{}", (Object)JSON.toJSONString((Object)dtQuery), (Object)"keylist_is_null");
        }
        int db = dtQuery.getDbIndex();
        JSONArray result = new JSONArray();
        try {
            ArrayList<String> keysNew = new ArrayList<String>();
            for (String key : keylist) {
                key = this.addKeyPrefix(key);
                keysNew.add(key);
            }
            String[] keys = new String[keysNew.size()];
            keysNew.toArray(keys);
            List<String> list = this.getListString(dtQuery, db, keys);
            for (String str : list) {
                if (str == null) continue;
                String obj = str.startsWith("{") && str.endsWith("}") ? JSON.parseObject((String)str, (Feature[])new Feature[]{Feature.OrderedField}) : str;
                result.add((Object)obj);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    private List<String> getListString(DtQuery dtQuery, int db, String[] keys) {
        return this.redisSentinelReadUtil.getValues(db, keys);
    }

    @Override
    public List<String> queryTop(DtTopQuery dtTopQuery) {
        int db = dtTopQuery.getDbIndex();
        String key = dtTopQuery.getKey();
        key = this.addKeyPrefix(key);
        long start = dtTopQuery.getStart();
        long end = dtTopQuery.getEnd();
        Set<String> set = this.redisSentinelReadUtil.zrevrange(db, key, start, end);
        ArrayList<String> result = new ArrayList<String>(set);
        return result;
    }

    @Override
    public Map<String, Double> queryTopWithScore(DtTopQuery dtQuery) {
        int db = dtQuery.getDbIndex();
        String key = dtQuery.getKey();
        key = this.addKeyPrefix(key);
        long start = dtQuery.getStart();
        long end = dtQuery.getEnd();
        String orderType = dtQuery.getOrderType();
        if (orderType == null) {
            orderType = "desc";
        }
        Map<String, Double> valueMap = new LinkedHashMap<String, Double>();
        if ("desc".equals(orderType)) {
            valueMap = this.redisSentinelReadUtil.zrevrangeWithScores(db, key, start, end);
        } else if ("asc".equals(orderType)) {
            valueMap = this.redisSentinelReadUtil.zrangeWithScores(db, key, start, end);
        }
        return valueMap;
    }

    @Override
    public List<String> fuzzyQuery(DtFuzzyQuery dtQuery) {
        String pattern = dtQuery.getPattern();
        int limit = dtQuery.getLimit();
        int db = dtQuery.getDbIndex();
        return this.redisSentinelReadUtil.scanLimitForSear(pattern, limit, db);
    }

    @Override
    public List<String> fuzzySearch(DtFuzzyQuery dtQuery) {
        String pattern = dtQuery.getPattern();
        int limit = dtQuery.getLimit();
        int db = dtQuery.getDbIndex();
        return this.redisSentinelReadUtil.scanLimit(pattern, limit, db);
    }

    @Override
    public Long insertHash(DtHashDO dtHashDO) {
        int db = dtHashDO.getDbIndex();
        String key = dtHashDO.getKey();
        key = this.addKeyPrefix(key);
        String field = dtHashDO.getField();
        String value = dtHashDO.getValue();
        return this.redisSentinelWriteUtil.hsetValue(db, key, field, value);
    }

    @Override
    public Long hdelValue(Integer dbIndex, String key, String ... field) {
        key = this.addKeyPrefix(key);
        return this.redisSentinelWriteUtil.hdelValue(dbIndex, key, field);
    }

    @Override
    public Long delValue(int db, String key) {
        key = this.addKeyPrefix(key);
        return this.redisSentinelWriteUtil.delValue(db, key);
    }

    @Override
    public String insertMultiFieldHash(DtHashDO dtHashDO) {
        int db = dtHashDO.getDbIndex();
        String key = dtHashDO.getKey();
        key = this.addKeyPrefix(key);
        Map<String, String> fields = dtHashDO.getFields();
        return this.redisSentinelWriteUtil.hmsetValue(db, key, fields);
    }

    @Override
    public Integer insertValue(DtHashDO dtHashDO) {
        int db = dtHashDO.getDbIndex();
        String key = dtHashDO.getKey();
        key = this.addKeyPrefix(key);
        String value = dtHashDO.getValue();
        Integer expTime = dtHashDO.getExpTime();
        Integer ret = null;
        ret = expTime == null ? Integer.valueOf(this.redisSentinelWriteUtil.setValue(db, key, value)) : Integer.valueOf(this.redisSentinelWriteUtil.setex(db, key, value, expTime));
        return ret;
    }

    @Override
    public Long expire(Integer db, String key, Integer seconds) {
        key = this.addKeyPrefix(key);
        return this.redisSentinelWriteUtil.expire(db, key, seconds);
    }

    @Override
    public Long lpushList(Integer db, String key, String[] values) {
        key = this.addKeyPrefix(key);
        return this.redisSentinelWriteUtil.lpushList(db, key, values);
    }

    @Override
    public Long sadd(Integer db, String key, String ... members) {
        key = this.addKeyPrefix(key);
        return this.redisSentinelWriteUtil.sadd(db, key, members);
    }

    @Override
    public Integer setex(Integer db, String key, String value, Integer seconds) {
        key = this.addKeyPrefix(key);
        return this.redisSentinelWriteUtil.setex(db, key, value, seconds);
    }

    @Override
    public Map<String, String> hscan(String key, String pattern, Integer count, Integer db) {
        key = this.addKeyPrefix(key);
        return this.redisSentinelReadUtil.hscan(key, pattern, count, (int)db);
    }

    @Override
    public String getValue(int db, String key) {
        key = this.addKeyPrefix(key);
        return this.redisSentinelReadUtil.getValue(db, key);
    }

    @Override
    public Map<String, Object> hmgetValue(Integer db, String objectName, String ... fields) {
        objectName = this.addKeyPrefix(objectName);
        return this.redisSentinelReadUtil.hmgetValue(db, objectName, fields);
    }

    @Override
    public Boolean exists(Integer db, String key) {
        key = this.addKeyPrefix(key);
        return this.redisSentinelReadUtil.exists(db, key);
    }

    @Override
    public List<String> getList(Integer db, String key, Long start, Long end) {
        key = this.addKeyPrefix(key);
        return this.redisSentinelReadUtil.getList(db, key, start, end);
    }

    @Override
    public Set<String> smembers(Integer db, String key) {
        key = this.addKeyPrefix(key);
        return this.redisSentinelReadUtil.smembers(db, key);
    }

    @Override
    public Set<String> zrange(Integer db, String key, long start, long end) {
        key = this.addKeyPrefix(key);
        return this.redisSentinelReadUtil.zrange(db, key, start, end);
    }

    private String addKeyPrefix(String key) {
        if (StringUtils.isBlank((CharSequence)key)) {
            return key;
        }
        if (StringUtils.isNotBlank((CharSequence)this.keyPrefix)) {
            key = this.keyPrefix + ":" + key;
        }
        return key;
    }
}

