/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.redis.process;

import com.alibaba.fastjson.JSONObject;
import com.manatee.common.domain.ResultCode;
import com.manatee.common.exception.BizException;
import com.manatee.common.util.StringUtil;
import com.manatee.lowcode.iutil.IOutputUtil;
import com.manatee.lowcode.iutil.IProcessConfUtil;
import com.manatee.lowcode.iutil.IVariableUtil;
import com.manatee.process.IProcess;
import com.manatee.process.domain.ProcessContent;
import com.manatee.process.domain.Step;
import com.manatee.redis.source.DtSourceManager;
import com.manatee.redis.util.RedisDbUtil;
import java.util.Set;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class RedisSetQueryProcess
implements IProcess {
    private Logger log = LoggerFactory.getLogger(RedisSetQueryProcess.class);
    @Resource
    private DtSourceManager dtSourceManager;
    @Resource
    private IOutputUtil outputUtil;
    @Resource
    private IVariableUtil variableUtil;
    @Resource
    private IProcessConfUtil processConfUtil;

    public void process(ProcessContent content) throws BizException {
        Step step = content.getStep();
        JSONObject conf = step.getConf();
        this.processConfUtil.checkConf(content, new String[]{"key"});
        int db = RedisDbUtil.getRedisDB(content);
        String objectKey = this.variableUtil.calVarInConf(content, "key");
        Set<String> resultList = this.dtSourceManager.getDtSource().smembers(db, objectKey);
        if (StringUtil.isBlank((String)conf.getString("returnKey"))) {
            content.getStepConf().put("returnKey", (Object)objectKey);
        }
        if (resultList == null || resultList.size() == 0) {
            this.log.warn("[GetRedisSetMembersProcess.process]_biz_occur,msg:{}", (Object)("result_is_null,key:" + objectKey));
            throw new BizException(ResultCode.RESULT_IS_NULL, "result_is_null");
        }
        this.outputUtil.handleAndPutData(content, resultList);
        this.log.warn("[GetRedisSetMembersProcess.process]_biz_occur,msg:{}", (Object)("object_key:" + objectKey));
    }

    public String getName() {
        return "redisSetQuery";
    }
}

