/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.redis.process;

import com.alibaba.fastjson.JSONObject;
import com.manatee.common.domain.ResultCode;
import com.manatee.common.domain.StrSplit;
import com.manatee.common.exception.BizException;
import com.manatee.lowcode.iutil.IOutputUtil;
import com.manatee.lowcode.iutil.IProcessConfUtil;
import com.manatee.lowcode.iutil.IVariableUtil;
import com.manatee.process.IProcess;
import com.manatee.process.domain.ProcessContent;
import com.manatee.process.domain.Step;
import com.manatee.redis.source.DtSourceManager;
import com.manatee.redis.util.RedisDbUtil;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class RedisHashFieldsQueryProcess
implements IProcess {
    private Logger log = LoggerFactory.getLogger(RedisHashFieldsQueryProcess.class);
    @Resource
    private IVariableUtil variableUtil;
    @Resource
    private DtSourceManager dtSourceManager;
    @Resource
    protected IOutputUtil outputUtil;
    @Resource
    private IProcessConfUtil processConfUtil;

    public void process(ProcessContent content) throws BizException {
        Step step = content.getStep();
        JSONObject conf = step.getConf();
        this.processConfUtil.checkConf(content, new String[]{"key", "input"});
        int db = RedisDbUtil.getRedisDB(content);
        String objectKey = conf.getString("key");
        objectKey = this.variableUtil.calVar(content, objectKey);
        String input = conf.getString("input");
        String[] fields = input.split(StrSplit.D);
        Map<String, Object> resultMap = this.dtSourceManager.getDtSource().hmgetValue(db, objectKey, fields);
        if (resultMap == null || resultMap.isEmpty()) {
            this.log.warn("[GetRedisHashFieldsProcess.process]_biz_occur,msg:{}", (Object)("result_is_null,key:" + objectKey + ",input:" + input));
            throw new BizException(ResultCode.RESULT_IS_NULL, "result_is_null");
        }
        this.outputUtil.handleAndPutData(content, resultMap);
        this.log.warn("[GetRedisHashFieldsProcess.process]_biz_occur,msg:{}", (Object)("object_key:" + objectKey + ",input:" + input));
    }

    public String getName() {
        return "redisHashFieldsQuery";
    }
}

