/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.redis.process;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.manatee.common.exception.BizException;
import com.manatee.lowcode.iutil.IInputUtil;
import com.manatee.lowcode.iutil.IProcessConfUtil;
import com.manatee.lowcode.iutil.IVariableUtil;
import com.manatee.process.IProcess;
import com.manatee.process.domain.ProcessContent;
import com.manatee.redis.domain.DtHashDO;
import com.manatee.redis.source.DtSourceManager;
import com.manatee.redis.util.RedisDbUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class RedisHashFieldsAddProcess
implements IProcess {
    @Resource
    private DtSourceManager dtSourceManager;
    @Resource
    private IInputUtil inputUtil;
    @Resource
    private IProcessConfUtil processConfUtil;
    @Resource
    private IVariableUtil variableUtil;
    private Logger log = LoggerFactory.getLogger(RedisHashFieldsAddProcess.class);

    public void process(ProcessContent content) throws BizException {
        this.processConfUtil.checkConf(content, new String[]{"key"});
        Map resResultMp = this.inputUtil.getHandleObject(content, "output");
        this.addToRedis(content, resResultMp);
    }

    protected void addToRedis(ProcessContent content, Map<String, Object> resResultMp) throws BizException {
        DtHashDO dtHashDO = this.getDtHashDO(content, resResultMp);
        if (dtHashDO.getFields() == null || dtHashDO.getFields().size() == 0) {
            return;
        }
        this.dtSourceManager.addMultiFieldHashToRedis(dtHashDO);
    }

    private DtHashDO getDtHashDO(ProcessContent content, Map<String, Object> resResultMp) {
        DtHashDO dtHashDO = new DtHashDO();
        JSONObject conf = content.getStepConf();
        String key = this.variableUtil.calVarInConf(content, "key");
        int db = RedisDbUtil.getRedisDB(content);
        dtHashDO.setDbIndex(db);
        dtHashDO.setKey(key);
        if (conf.containsKey((Object)"isStaticRedis")) {
            dtHashDO.setStaticRedis(conf.getBoolean("isStaticRedis"));
        }
        Map<String, String> fields = this.convertValue(resResultMp);
        dtHashDO.setFields(fields);
        return dtHashDO;
    }

    private Map<String, String> convertValue(Map<String, Object> resResultMp) {
        HashMap<String, String> fields = new HashMap<String, String>();
        for (String field : resResultMp.keySet()) {
            Object fieldV = resResultMp.get(field);
            String valueStr = fieldV instanceof Map || fieldV instanceof List ? JSON.toJSONString((Object)fieldV) : String.valueOf(fieldV);
            fields.put(field, valueStr);
        }
        return fields;
    }

    public String getName() {
        return "redisHashFieldsAdd";
    }
}

