/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.elasticsearch.process;

import com.manatee.common.exception.BizException;
import com.manatee.elasticsearch.domain.ESDelete;
import com.manatee.elasticsearch.manager.ESManager;
import com.manatee.lowcode.iutil.IOutputUtil;
import com.manatee.lowcode.util.ProcessConfUtil;
import com.manatee.process.IProcess;
import com.manatee.process.domain.ProcessContent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.springframework.stereotype.Service;

@Service
public class ElasticsearchDeleteProcess
implements IProcess {
    @Resource
    private ProcessConfUtil processConfUtil;
    @Resource
    private IOutputUtil outputUtil;
    @Resource
    RestHighLevelClient restHighLevelClient;
    @Resource
    private ESManager esManager;

    public void process(ProcessContent content) throws BizException {
        this.processConfUtil.checkConf(content, new String[]{"index"});
        ESDelete esDelete = this.esManager.getESDelete(content);
        BulkRequest request = this.getBulkRequest(esDelete);
        BulkResponse bulkResponse = this.getBulkResponse(request);
        Object result = this.getResult(content, bulkResponse);
        this.outputUtil.putData(content, result);
    }

    private BulkRequest getBulkRequest(ESDelete esDelete) {
        BulkRequest request = new BulkRequest();
        String index = esDelete.getIndex();
        if (esDelete.getDeleteOne().booleanValue()) {
            String id = esDelete.getId();
            request.add(new DeleteRequest(index, id));
        } else {
            List<String> idList = esDelete.getIdList();
            for (String id : idList) {
                request.add(new DeleteRequest(index, id));
            }
        }
        return request;
    }

    private BulkResponse getBulkResponse(BulkRequest request) throws BizException {
        try {
            BulkResponse bulkResponse = this.restHighLevelClient.bulk(request, RequestOptions.DEFAULT);
            return bulkResponse;
        }
        catch (IOException e) {
            BizException bizException = new BizException((Throwable)e);
            bizException.setMsg(e.getMessage());
            throw bizException;
        }
    }

    private Object getResult(ProcessContent content, BulkResponse bulkResponse) {
        this.outputUtil.setDefaultReturnKey(content, "count");
        BulkItemResponse[] items = bulkResponse.getItems();
        ArrayList<String> itemIds = new ArrayList<String>();
        for (BulkItemResponse item : items) {
            String result = item.getResponse().getResult().getLowercase();
            if ("not_found".equals(result)) continue;
            itemIds.add(item.getId());
        }
        if (itemIds.size() > 0) {
            return itemIds.size();
        }
        return 0;
    }

    public String getName() {
        return "elasticsearchDelete";
    }
}

