/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.fun.time;

import com.manatee.common.domain.ResultCode;
import com.manatee.common.exception.BizException;
import com.manatee.fun.AbstractFunction;
import com.manatee.fun.domain.FunctionContent;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class CalculateAgeFun
extends AbstractFunction {
    protected static Logger LOGGER = LoggerFactory.getLogger(CalculateAgeFun.class);

    public String getName() {
        return "calculateAge";
    }

    public Object doFunction(FunctionContent content) throws BizException {
        Date currentDate;
        Date birthDate;
        this.checkParamSize(content);
        if (!this.checkParamExist(content).booleanValue()) {
            return null;
        }
        List parameters = content.getParameters();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Object obj1 = content.getParameter(0);
        try {
            birthDate = sdf.parse(String.valueOf(obj1));
            if (parameters.size() > 1) {
                Object obj2 = content.getParameter(1);
                currentDate = sdf.parse(String.valueOf(obj2));
            } else {
                currentDate = new Date();
            }
        }
        catch (Exception e) {
            throw new BizException(ResultCode.PARAM_IS_ERROR, "\u8bf7\u68c0\u67e5\u5165\u53c2\u683c\u5f0f");
        }
        Calendar birth = Calendar.getInstance();
        birth.setTime(birthDate);
        Calendar current = Calendar.getInstance();
        current.setTime(currentDate);
        int age = current.get(1) - birth.get(1);
        if (current.get(2) < birth.get(2) || current.get(2) == birth.get(2) && current.get(5) < birth.get(5)) {
            --age;
        }
        return age;
    }

    public Integer getMinParamSize() {
        return 1;
    }

    public Integer getMaxParamSize() {
        return 2;
    }
}

