/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.webservice.type;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.manatee.common.exception.BizException;
import com.manatee.lowcode.iutil.IInputUtil;
import com.manatee.lowcode.iutil.IOutputUtil;
import com.manatee.lowcode.util.VariableUtil;
import com.manatee.lowcode.util.XmlUtils;
import com.manatee.process.domain.ProcessContent;
import java.util.Map;
import javax.annotation.Resource;

public class BaseWebServiceClient {
    @Resource
    protected IInputUtil inputUtil;
    @Resource
    protected IOutputUtil outputUtil;
    @Resource
    private VariableUtil variableUtil;

    protected Object[] getParams(ProcessContent content, String url) throws BizException {
        Object paramObject = content.getStepConf().get((Object)"params");
        JSONObject paramJson = null;
        if (paramObject instanceof JSONObject || paramObject instanceof Map) {
            paramJson = (JSONObject)paramObject;
        }
        Map paramMap = this.inputUtil.getHandleObject(content);
        Object[] params = new Object[paramMap.size()];
        int index = 0;
        for (Map.Entry aMap : paramMap.entrySet()) {
            Object value = aMap.getValue();
            if (null == value && paramJson != null) {
                value = paramJson.get(aMap.getKey());
            }
            params[index] = value;
            ++index;
        }
        if (url.indexOf("/ws/modularity") == -1) {
            return params;
        }
        if (params.length >= 1) {
            params[0] = Long.valueOf(params[0] + "");
        }
        if (params.length >= 3) {
            Map map = (Map)params[2];
            JSONObject json = new JSONObject();
            json.putAll(map);
            params[2] = json.toJSONString();
        }
        return params;
    }

    protected String getUrl(ProcessContent content) throws BizException {
        String url = this.variableUtil.calVarInConf(content, "url");
        if (url.indexOf("?wsdl") == -1) {
            url = url + "?wsdl";
        }
        return url;
    }

    protected void handleData(ProcessContent content, Object data) throws BizException {
        Object value;
        if (data == null) {
            return;
        }
        if (XmlUtils.isXml((Object)data)) {
            value = XmlUtils.xmlToJson((String)((String)data));
        } else {
            String strJson = data instanceof String ? (String)data : JSON.toJSONString((Object)data);
            try {
                JSONObject aJson;
                value = aJson = JSONObject.parseObject((String)strJson);
                Object json = aJson.get((Object)"string");
                if (json != null) {
                    value = json;
                }
            }
            catch (Throwable e) {
                value = data;
            }
        }
        this.outputUtil.handleAndPutData(content, value);
    }
}

