/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.lowcode.java.manager;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.ttl.TransmittableThreadLocal;
import com.manatee.common.exception.BizException;
import com.manatee.fun.FunctionUtil;
import com.manatee.fun.domain.FunctionContent;
import com.manatee.process.domain.ProcessContent;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class JavaCodeBase {
    private static final TransmittableThreadLocal<ProcessContent> PROCESS_CONTENT = new TransmittableThreadLocal();
    private String manateeJavaCodeVersion;
    @Resource
    private FunctionUtil functionUtil;

    public String getManateeJavaCodeVersion() {
        return this.manateeJavaCodeVersion;
    }

    public void setManateeJavaCodeVersion(String manateeJavaCodeVersion) {
        this.manateeJavaCodeVersion = manateeJavaCodeVersion;
    }

    public void putContent(ProcessContent processContent) {
        PROCESS_CONTENT.set((Object)processContent);
    }

    public ProcessContent getContent() {
        return (ProcessContent)PROCESS_CONTENT.get();
    }

    public void clearContent() {
    }

    public Object get(String key) {
        ProcessContent content = this.getContent();
        return this.get(content, key);
    }

    public Object get(ProcessContent processContent, String key) {
        if (processContent == null) {
            return null;
        }
        return processContent.getValue(key);
    }

    public <T> T getObject(ProcessContent processContent, String key, Class<T> clazz) {
        if (processContent == null) {
            return null;
        }
        return (T)processContent.getValue(key);
    }

    public <T> T getObject(String key, Class<T> clazz) {
        ProcessContent content = this.getContent();
        return this.getObject(content, key, clazz);
    }

    public void put(String key, Object value) {
        ProcessContent content = this.getContent();
        this.put(content, key, value);
    }

    public void put(ProcessContent processContent, String key, Object value) {
        processContent.putRequest(key, value);
    }

    public void putAndReturn(String key, Object value) {
        ProcessContent content = this.getContent();
        this.putAndReturn(content, key, value);
    }

    public void putAndReturn(ProcessContent processContent, String key, Object value) {
        if (processContent == null) {
            return;
        }
        processContent.putRequestSubValue(key, value);
        processContent.putResponseSubValue(key, value);
    }

    public JSONObject getJSONObject(String key) {
        Object value = this.get(key);
        if (value == null) {
            return null;
        }
        return (JSONObject)value;
    }

    public String getString(String key) {
        Object value = this.get(key);
        if (value == null) {
            return null;
        }
        return (String)value;
    }

    public Integer getInteger(String key) {
        Object value = this.get(key);
        if (value == null) {
            return null;
        }
        if (value instanceof Integer) {
            return (Integer)value;
        }
        return Integer.parseInt(value.toString());
    }

    public Boolean getBoolean(String key) {
        Object value = this.get(key);
        if (value == null) {
            return null;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        return Boolean.parseBoolean(value.toString());
    }

    public Long getLong(String key) {
        Object value = this.get(key);
        if (value == null) {
            return null;
        }
        if (value instanceof Long) {
            return (Long)value;
        }
        return Long.parseLong(value.toString());
    }

    public Double getDouble(String key) {
        Object value = this.get(key);
        if (value == null) {
            return null;
        }
        if (value instanceof Double) {
            return (Double)value;
        }
        return Double.parseDouble(value.toString());
    }

    public JSONArray getJSONArray(String key) {
        Object value = this.get(key);
        if (value == null) {
            return null;
        }
        return (JSONArray)value;
    }

    public List getList(String key) {
        return this.getObject(key, List.class);
    }

    public Map getMap(String key) {
        return this.getObject(key, Map.class);
    }

    public Object doFun(String funName, Object ... params) throws BizException {
        FunctionContent funContent = new FunctionContent();
        ProcessContent content = this.getContent();
        funContent.setRequest(content.getRequest());
        funContent.setResponse(content.getResponse());
        funContent.setStep(content.getStep());
        funContent.setTemp(content.getTemp());
        funContent.addTempData(content.getTempData());
        List<Object> parameters = Arrays.asList(params);
        funContent.setParameters(parameters);
        return this.functionUtil.function(funName, funContent);
    }
}

