/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.lowcodedb.newdb.sql;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.manatee.common.util.ArrayUtils;
import com.manatee.common.util.StrUtils;
import com.manatee.common.util.tool.core.util.StrUtil;
import com.manatee.lowcodedb.newdb.ThreadLocalConnection;
import com.manatee.process.domain.ProcessContent;
import com.manatee.process.domain.Step;
import com.manatee.process.execute.DebugUtil;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum SqlLog {
    INSTANCE;

    public static final String KEY_SHOW_SQL = "showSql";
    public static final String KEY_FORMAT_SQL = "formatSql";
    public static final String KEY_SHOW_PARAMS = "showParams";
    public static final String KEY_SQL_LEVEL = "sqlLevel";
    private static final Logger LOGGER;
    private boolean showSql;
    private boolean formatSql;
    private boolean showParams;
    private int level = 1;

    public void init(boolean isShowSql, boolean isFormatSql, boolean isShowParams, int level) {
        this.showSql = isShowSql;
        this.formatSql = isFormatSql;
        this.showParams = isShowParams;
        this.level = level;
    }

    public void log(String sql) {
        this.log(sql, null);
    }

    public void logForBatch(String sql, Object paramValues) {
        this.logToProcess(sql, paramValues);
        if (this.showSql) {
            if (this.level == 1) {
                LOGGER.info("\n[MANATEE Batch SQL] -> {}", (Object)sql);
            } else {
                LOGGER.debug("\n[MANATEE Batch SQL] -> {}", (Object)sql);
            }
        }
    }

    public void log(String sql, Object paramValues) {
        this.logToProcess(sql, paramValues);
        if (this.showSql) {
            if (null != paramValues && this.showParams) {
                if (this.level == 1) {
                    LOGGER.info("\n[MANATEE SQL] -> {}\nParams -> {}", (Object)sql, paramValues);
                } else {
                    LOGGER.debug("\n[MANATEE SQL] -> {}\nParams -> {}", (Object)sql, paramValues);
                }
            } else if (this.level == 1) {
                LOGGER.info("\n[MANATEE SQL] -> {}", (Object)sql);
            } else {
                LOGGER.debug("\n[MANATEE SQL] -> {}", (Object)sql);
            }
        }
    }

    private void logToProcess(String sql, Object paramValues) {
        ProcessContent content = ThreadLocalConnection.INSTANCE.getProcessContent();
        if (content != null && DebugUtil.isDebug((ProcessContent)content) && content.getStep() != null) {
            JSONObject executeSqlObj = new JSONObject(true);
            String paramValuesStr = JSONObject.toJSONString((Object)paramValues);
            String modulePath = "";
            if (content.getModulePathList() != null && content.getModulePathList().size() > 0) {
                modulePath = StringUtils.join((Iterable)content.getModulePathList(), (String)"==>");
                modulePath = modulePath + "==>";
            }
            executeSqlObj.put("stepName", (Object)(modulePath + content.getStep().getTitle()));
            executeSqlObj.put("executeSql", (Object)(sql + (paramValues != null ? "\r\n" + paramValuesStr : "")));
            executeSqlObj.put("nodeId", (Object)content.getStep().getId());
            if (StringUtils.isNotBlank((CharSequence)modulePath)) {
                executeSqlObj.put("type", (Object)"module");
            } else {
                executeSqlObj.put("type", (Object)"step");
            }
            if (StrUtil.isNotEmpty((CharSequence)paramValuesStr) && sql.contains("?")) {
                try {
                    JSONArray jsonArray = JSONArray.parseArray((String)paramValuesStr);
                    if (jsonArray.size() > 0) {
                        Step step = content.getStep();
                        if ((StringUtils.equals((CharSequence)step.getName(), (CharSequence)"manateeInsertProcess") || StringUtils.equals((CharSequence)step.getName(), (CharSequence)"manateeInsertProcess_v2")) && StringUtils.equals((CharSequence)step.getConf().getString("handleType"), (CharSequence)"batch")) {
                            StringBuilder replaceSqlSb = new StringBuilder();
                            for (Object o : jsonArray) {
                                JSONArray array = (JSONArray)o;
                                String replaceSql = this.sqlFormat(sql, array.toArray());
                                replaceSqlSb.append(replaceSql);
                                if (replaceSql.endsWith(";")) continue;
                                replaceSqlSb.append(";");
                            }
                            executeSqlObj.put("replaceSql", (Object)replaceSqlSb.toString());
                        } else {
                            String replaceSql = this.sqlFormat(sql, jsonArray.toArray());
                            executeSqlObj.put("replaceSql", (Object)replaceSql);
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            content.getDebug().putExecuteSqls(executeSqlObj);
        }
    }

    private String sqlFormat(String sql, Object ... argArray) {
        if (!StrUtils.isBlank((String)sql) && !ArrayUtils.isEmpty((Object[])argArray)) {
            int strPatternLength = sql.length();
            StringBuilder sbuf = new StringBuilder(strPatternLength + 50);
            int handledPosition = 0;
            for (int argIndex = 0; argIndex < argArray.length; ++argIndex) {
                int delimIndex = sql.indexOf("?", handledPosition);
                if (delimIndex == -1) {
                    if (handledPosition == 0) {
                        return sql;
                    }
                    sbuf.append(sql, handledPosition, strPatternLength);
                    return sbuf.toString();
                }
                sbuf.append(sql, handledPosition, delimIndex);
                Object obj = argArray[argIndex];
                if (obj instanceof String) {
                    sbuf.append("'").append(obj).append("'");
                } else if (obj instanceof Map) {
                    sbuf.append("'").append(JSONObject.toJSONString((Object)obj)).append("'");
                } else if (obj instanceof List) {
                    sbuf.append("'").append(JSONObject.toJSONString((Object)obj)).append("'");
                } else {
                    sbuf.append(obj);
                }
                handledPosition = delimIndex + 1;
            }
            sbuf.append(sql, handledPosition, sql.length());
            return sbuf.toString();
        }
        return sql;
    }

    static {
        LOGGER = LoggerFactory.getLogger(SqlLog.class);
    }
}

