/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.lowcodedb.newdb.ds.hikari;

import com.manatee.common.util.tool.core.util.StrUtil;
import com.manatee.lowcodedb.newdb.ds.AbstractDSFactory;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;

public class HikariDSFactory
extends AbstractDSFactory {
    private static final long serialVersionUID = -8834744983614749401L;
    public static final String DS_NAME = "HikariCP";

    public HikariDSFactory() {
        this((HashMap<String, String>)null);
    }

    public HikariDSFactory(HashMap<String, String> setting) {
        super(DS_NAME, HikariDataSource.class, setting);
    }

    @Override
    protected DataSource createDataSource(String jdbcUrl, String driver, String user, String pass, HashMap<String, String> poolSetting) {
        Properties connProps = new Properties();
        for (String key : KEY_CONN_PROPS) {
            String connValue = poolSetting.get(key);
            if (!StrUtil.isNotBlank((CharSequence)connValue)) continue;
            connProps.setProperty(key, connValue);
        }
        Properties config = new Properties();
        config.putAll((Map<?, ?>)poolSetting);
        config.put("jdbcUrl", jdbcUrl);
        if (null != driver) {
            config.put("driverClassName", driver);
        }
        if (null != user) {
            config.put("username", user);
        }
        if (null != pass) {
            config.put("password", pass);
        }
        HikariConfig hikariConfig = new HikariConfig(config);
        hikariConfig.setDataSourceProperties(connProps);
        return new HikariDataSource(hikariConfig);
    }
}

