/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.lowcodedb.newdb;

import com.manatee.common.exception.BizException;
import com.manatee.common.util.tool.core.collection.CollUtil;
import com.manatee.lowcodedb.newdb.DbEntity;
import com.manatee.lowcodedb.newdb.DialectRunner;
import com.manatee.lowcodedb.newdb.Page;
import com.manatee.lowcodedb.newdb.PageResult;
import com.manatee.lowcodedb.newdb.dialect.Dialect;
import com.manatee.lowcodedb.newdb.dialect.DialectFactory;
import com.manatee.lowcodedb.newdb.handler.HandleHelper;
import com.manatee.lowcodedb.newdb.handler.ManateeListHandler;
import com.manatee.lowcodedb.newdb.handler.ManateePageResultHandler;
import com.manatee.lowcodedb.newdb.handler.RsHandler;
import com.manatee.lowcodedb.newdb.sql.Condition;
import com.manatee.lowcodedb.newdb.sql.DBQuery;
import com.manatee.lowcodedb.newdb.sql.Join;
import com.manatee.lowcodedb.newdb.sql.Order;
import com.manatee.lowcodedb.newdb.sql.SqlBuilder;
import com.manatee.lowcodedb.newdb.sql.SqlUtil;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import javax.sql.DataSource;

public class SqlConnRunner
extends DialectRunner {
    private static final long serialVersionUID = 1L;

    public static SqlConnRunner create(Dialect dialect) {
        return new SqlConnRunner(dialect);
    }

    public static SqlConnRunner create(DataSource ds) {
        return new SqlConnRunner(DialectFactory.getDialect(ds));
    }

    public static SqlConnRunner create(String driverClassName) {
        return new SqlConnRunner(driverClassName);
    }

    public SqlConnRunner(Dialect dialect) {
        super(dialect);
    }

    public SqlConnRunner(String driverClassName) {
        super(driverClassName);
    }

    public int[] insert(Connection conn, Collection<DbEntity> records) throws SQLException {
        return this.insert(conn, records.toArray(new DbEntity[0]));
    }

    public int insert(Connection conn, DbEntity record) throws SQLException {
        return this.insert(conn, new DbEntity[]{record})[0];
    }

    public List<Object> insertForGeneratedKeys(Connection conn, DbEntity record) throws SQLException {
        return this.insert(conn, record, HandleHelper::handleRowToList);
    }

    public Object insertForGeneratedKey(Connection conn, DbEntity record) throws SQLException {
        return this.insert(conn, record, (ResultSet rs) -> {
            Object generatedKey = null;
            if (rs != null) {
                if (rs.next()) {
                    try {
                        generatedKey = rs.getLong(1);
                    }
                    catch (SQLException sQLException) {}
                } else if (record.getPk() != null) {
                    String pkName = record.getPk();
                    try {
                        generatedKey = record.get(pkName);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            return generatedKey;
        });
    }

    public <T> T find(Connection conn, Collection<String> fields, DbEntity where, RsHandler<T> rsh, Order[] orders, Collection<Join> joins) throws SQLException {
        return this.find(conn, DBQuery.of(where).setFields(fields).setOrders(orders).setJoins(joins).setGetOne(where.getGetOne()), rsh);
    }

    public <T> T find(Connection conn, DbEntity where, RsHandler<T> rsh, String ... fields) throws SQLException {
        return this.find(conn, CollUtil.newArrayList((Object[])fields), where, rsh, null, null);
    }

    public List<DbEntity> find(Connection conn, DbEntity where) throws SQLException {
        return this.find(conn, where.getFieldNames(), where, new ManateeListHandler(this.caseInsensitive), null, null);
    }

    public List<DbEntity> findAll(Connection conn, DbEntity where) throws SQLException {
        return this.find(conn, where, new ManateeListHandler(this.caseInsensitive), new String[0]);
    }

    public List<DbEntity> findAll(Connection conn, String tableName) throws SQLException, BizException {
        return this.findAll(conn, DbEntity.create(tableName));
    }

    public List<DbEntity> findBy(Connection conn, String tableName, String field, Object value) throws SQLException, BizException {
        return this.findAll(conn, DbEntity.create(tableName).set(field, value));
    }

    public List<DbEntity> findLike(Connection conn, String tableName, String field, String value, Condition.LikeType likeType) throws SQLException, BizException {
        return this.findAll(conn, DbEntity.create(tableName).set(field, SqlUtil.buildLikeValue(value, likeType, true)));
    }

    public List<DbEntity> findIn(Connection conn, String tableName, String field, Object ... values) throws SQLException, BizException {
        return this.findAll(conn, DbEntity.create(tableName).set(field, values));
    }

    public long count(Connection conn, CharSequence selectSql, Object ... params) throws SQLException {
        return this.count(conn, SqlBuilder.of(selectSql).addParams(params));
    }

    public <T> T page(Connection conn, Collection<String> fields, DbEntity where, int pageNumber, int numPerPage, RsHandler<T> rsh) throws SQLException {
        return this.page(conn, DBQuery.of(where).setFields(fields).setPage(new Page(pageNumber, numPerPage)), rsh);
    }

    public PageResult<DbEntity> page(Connection conn, SqlBuilder sqlBuilder, Page page) throws SQLException {
        ManateePageResultHandler pageResultHandler = new ManateePageResultHandler(new PageResult<DbEntity>(page.getPageNumber(), page.getPageSize(), (int)this.count(conn, sqlBuilder)), this.caseInsensitive, page.getCamelCase(), page.getUpperOrLowerCase());
        return this.page(conn, sqlBuilder, page, pageResultHandler);
    }

    public PageResult<DbEntity> page(Connection conn, SqlBuilder sqlBuilder, Page page, ManateePageResultHandler pageResultHandler) throws SQLException {
        return this.page(conn, sqlBuilder, page, pageResultHandler);
    }

    public PageResult<DbEntity> page(Connection conn, Collection<String> fields, DbEntity where, int page, int numPerPage) throws SQLException {
        return this.page(conn, fields, where, new Page(page, numPerPage));
    }

    public PageResult<DbEntity> page(Connection conn, DbEntity where, Page page) throws SQLException {
        return this.page(conn, null, where, page);
    }

    public PageResult<DbEntity> page(Connection conn, Collection<String> fields, DbEntity where, Page page) throws SQLException {
        ManateePageResultHandler pageResultHandler = new ManateePageResultHandler(new PageResult<DbEntity>(page.getPageNumber(), page.getPageSize(), (int)this.count(conn, where)), this.caseInsensitive, page.getCamelCase(), page.getUpperOrLowerCase());
        return this.page(conn, fields, where, page, pageResultHandler);
    }

    public <T> T page(Connection conn, Collection<String> fields, DbEntity where, Page page, RsHandler<T> handler) throws SQLException {
        return this.page(conn, DBQuery.of(where).setFields(fields).setOrders(page.getOrders()).setPage(page).setJoins(where.getJoins()), handler);
    }
}

