/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.camunda.process.task.handle;

import com.alibaba.fastjson.JSONObject;
import com.manatee.camunda.dto.TaskDTO;
import com.manatee.camunda.process.task.handle.TaskHandle;
import com.manatee.process.domain.ProcessContent;
import java.util.List;
import java.util.stream.Collectors;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.TaskService;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Task;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RefuseTaskHandle
implements TaskHandle {
    @Autowired
    private TaskService taskService;
    @Autowired
    private ProcessEngine processEngine;

    @Override
    public JSONObject handle(TaskDTO taskDTO) {
        String taskId = taskDTO.getTaskId();
        String processInstanceId = taskDTO.getProcessInstanceId();
        String message = taskDTO.getMessage();
        List activeTaskList = this.taskService.createTaskQuery().processInstanceId(processInstanceId).active().list();
        this.taskService.setVariable(taskId, "MANATEE_REFUSE_ACTIVEIDS", (Object)activeTaskList.stream().map(Task::getTaskDefinitionKey).collect(Collectors.joining(",")));
        this.taskService.setVariable(taskId, "MANATEE_REFUSE_PROCESSINSTANCEID", (Object)processInstanceId);
        this.taskService.createComment(taskId, processInstanceId, message);
        ProcessInstance processInstance = (ProcessInstance)this.processEngine.getRuntimeService().createProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
        if (processInstance != null && !processInstance.isEnded()) {
            this.processEngine.getRuntimeService().deleteProcessInstance(processInstanceId, "refuse@@:" + message);
        }
        return null;
    }

    @Override
    public TaskDTO build(TaskDTO taskDTO, ProcessContent content) {
        return taskDTO;
    }
}

