/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.camunda.process.task.handle;

import com.alibaba.fastjson.JSONObject;
import com.manatee.camunda.dto.TaskDTO;
import com.manatee.camunda.process.task.handle.TaskHandle;
import com.manatee.common.domain.ResultCode;
import com.manatee.common.exception.BizException;
import com.manatee.lowcode.util.VariableUtil;
import com.manatee.process.domain.ProcessContent;
import com.manatee.process.util.StringUtil;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.camunda.bpm.engine.TaskService;
import org.camunda.bpm.engine.task.Task;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ForwardTaskHandle
implements TaskHandle {
    @Autowired
    private TaskService taskService;
    @Resource
    private VariableUtil variableUtil;

    @Override
    public JSONObject handle(TaskDTO taskDTO) throws BizException {
        String processInstanceId = taskDTO.getProcessInstanceId();
        Task task = taskDTO.getTask();
        String message = taskDTO.getMessage();
        String recipient = taskDTO.getRecipient();
        if (StringUtil.isBlank((String)recipient)) {
            throw new BizException(ResultCode.BIZ_ERROR, "\u8bf7\u8f93\u5165\u8f6c\u4ea4\u4eba");
        }
        String forwardKey = "MANATEE_FORWARD_TASK_USER:" + (StringUtils.isNotBlank((CharSequence)task.getAssignee()) ? task.getAssignee() : "") + ":" + task.getTaskDefinitionKey();
        this.taskService.setVariable(task.getId(), forwardKey, (Object)recipient);
        this.taskService.delegateTask(task.getId(), recipient);
        this.taskService.createComment(task.getId(), processInstanceId, "forward@@:" + message);
        return null;
    }

    @Override
    public TaskDTO build(TaskDTO taskDTO, ProcessContent content) throws BizException {
        String recipient = this.getOneVarValue(content, "recipient");
        if (StringUtil.isBlank((String)recipient)) {
            throw new BizException(ResultCode.BIZ_ERROR, "\u8bf7\u8f93\u5165\u8f6c\u4ea4\u4eba");
        }
        taskDTO.setRecipient(recipient);
        return taskDTO;
    }

    private String getOneVarValue(ProcessContent content, String varKey) {
        Object varValueObj;
        String varKeyValue = this.variableUtil.calVarInConf(content, varKey);
        String varValue = null;
        if (StringUtil.isNotBlank((String)varKeyValue) && (varValueObj = content.getValue(varKeyValue)) != null) {
            varValue = varValueObj.toString();
        }
        return varValue;
    }
}

