package ${packagePath}.service.impl;

<#list importSet as import>
import ${import};
</#list>
import com.alibaba.fastjson.parser.Feature;
import org.springframework.stereotype.Service;
import com.manatee.lowcode.baseModule.manager.BaseModuleUtil;
import com.manatee.process.domain.ProcessContent;
import com.manatee.lowcode.domain.WebResult;
import com.manatee.lowcode.util.WebUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ${packagePath}.service.${className}Service;

/**
  * ${className}服务实现
  *
  * @author ${author!'-'} ${email!'-'}
  * @since ${version!'-'} ${.now}
*/
@Service
public class ${className}ServiceImpl implements ${className}Service {

    private static final Logger log = LoggerFactory.getLogger(${className}ServiceImpl.class);

    @Resource
    private WebUtil webUtil;

<#list resourceSet as resource>
    @Resource
    private ${resource};

</#list>

<#list codeBuilder as item>

    @Override
    public JSONObject ${funName[item_index]}Process (ProcessContent content) throws BizException {
${item}
       //返回值
       return getWebResult(content).toJson();
    }
</#list>

<#list privateFuns as privateFun>
${privateFun}
</#list>

    /**
    * 返回参数
    *
    * @author ${author!'-'} ${email!'-'}
    * @since ${version!'-'} ${.now}
    */
    private WebResult getWebResult(ProcessContent content) {
        //返回值
        WebResult result = webUtil.wirteToResult(content);
        if (WebUtil.isSuccessResult(result)) {
            log.warn("[CustomizeModuleManager.customize]_success,code:{},projectId:{}"
                , content.getCode(), content.getProjectId());
        } else{
            String re = null;
            Object reJson = result.toJson();
            if(reJson!=null){
                re = reJson.toString();
                if(re.length()>500){
                    re = re.substring(0,200);
                }
            }
            log.error("[CustomizeModuleManager.customize]_biz_error,code:{},projectId:{},result:{}"
                , content.getCode(), content.getProjectId(),re);
        }
        return result;
    }
}