/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.common.util.tool.core.map.multi;

import com.manatee.common.util.tool.core.collection.CollUtil;
import com.manatee.common.util.tool.core.map.MapWrapper;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public abstract class CollectionValueMap<K, V>
extends MapWrapper<K, Collection<V>> {
    private static final long serialVersionUID = 9012989578038102983L;
    protected static final int DEFAULT_COLLCTION_INITIAL_CAPACITY = 3;

    public CollectionValueMap() {
        this(16);
    }

    public CollectionValueMap(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public CollectionValueMap(Map<? extends K, ? extends Collection<V>> m) {
        this(0.75f, m);
    }

    public CollectionValueMap(float loadFactor, Map<? extends K, ? extends Collection<V>> m) {
        this(m.size(), loadFactor);
        this.putAll(m);
    }

    public CollectionValueMap(int initialCapacity, float loadFactor) {
        super(new HashMap(initialCapacity, loadFactor));
    }

    public void putValue(K key, V value) {
        Collection<V> collection = (Collection<V>)this.get(key);
        if (null == collection) {
            collection = this.createCollection();
            this.put(key, collection);
        }
        collection.add(value);
    }

    public V get(K key, int index) {
        Collection collection = (Collection)this.get(key);
        return (V)CollUtil.get(collection, index);
    }

    protected abstract Collection<V> createCollection();
}

