/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.ses.process;

import com.manatee.common.exception.BizException;
import com.manatee.lowcode.util.ProcessConfUtil;
import com.manatee.lowcode.util.VariableUtil;
import com.manatee.process.IProcess;
import com.manatee.process.domain.ProcessContent;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.mail.SimpleMailMessage;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.stereotype.Service;

@Service
public class SendEmailProcess
implements IProcess {
    @Value(value="${spring.mail.username:}")
    private String usernameInSpringMail;
    @Autowired
    private JavaMailSender mailSender;
    @Autowired
    private ProcessConfUtil processConfUtil;
    @Resource
    private VariableUtil variableUtil;

    public void process(ProcessContent content) throws BizException {
        this.processConfUtil.checkConf(content, new String[]{"to"});
        String to = this.variableUtil.calVarInConf(content, "to");
        String subject = this.variableUtil.calVarInConf(content, "subject");
        String contentStr = this.variableUtil.calVarInConf(content, "content");
        SimpleMailMessage msg = new SimpleMailMessage();
        msg.setFrom(this.usernameInSpringMail);
        msg.setTo(to);
        msg.setSubject(subject);
        msg.setText(contentStr);
        this.mailSender.send(msg);
    }

    public String getName() {
        return "sendEmail";
    }
}

