/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.lowcode.process.end;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.manatee.check.CheckConditionUtil;
import com.manatee.common.domain.ResultCode;
import com.manatee.common.exception.BizException;
import com.manatee.common.util.CollectionUtils;
import com.manatee.common.util.StringUtil;
import com.manatee.common.util.tool.core.util.NumberUtil;
import com.manatee.lowcode.util.InputUtil;
import com.manatee.lowcode.util.OutputUtil;
import com.manatee.lowcode.util.ProcessConfUtil;
import com.manatee.lowcode.util.VariableUtil;
import com.manatee.process.IProcess;
import com.manatee.process.domain.ProcessContent;
import com.manatee.process.util.ManateeConditionUtil;
import com.manatee.process.util.ProjectConfUtil;
import java.util.Collection;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class ReturnProcess
implements IProcess {
    @Resource
    private InputUtil inputUtil;
    @Resource
    private OutputUtil outputUtil;
    @Resource
    private VariableUtil variableUtil;
    @Resource
    private ProcessConfUtil processConfUtil;
    @Resource
    private ManateeConditionUtil manateeConditionUtil;

    public void process(ProcessContent content) throws BizException {
        String resultCodeStr;
        String resultStatus;
        JSONArray checkConditionArray;
        this.processConfUtil.checkConf(content, null);
        String expression = content.getStepConfString("expression");
        if (expression == null && (checkConditionArray = content.getStepConf().getJSONArray("checkConditionArray")) != null && checkConditionArray.size() > 0) {
            JSONObject checkConditionJson = CheckConditionUtil.checkConditionPackage((JSONArray)checkConditionArray);
            expression = checkConditionJson.getString("checkCondition");
        }
        Boolean happened = false;
        if (StringUtil.isNotEmpty((CharSequence)expression)) {
            happened = this.manateeConditionUtil.isHappened(expression, content);
        }
        if (!happened.booleanValue()) {
            return;
        }
        JSONObject conf = content.getStepConf();
        conf.put("valueTo", (Object)"response");
        content.putRequest("manatee_return_flag", (Object)Boolean.TRUE);
        content.putRequest("manatee_break_flag", (Object)Boolean.TRUE);
        String returnMsg = this.variableUtil.calVarInConf(content, "returnMsg");
        if (StringUtil.isNotEmpty((CharSequence)returnMsg)) {
            content.putRequestSubValue("outputMsg", (Object)returnMsg);
        }
        if (NumberUtil.isNumber((CharSequence)(resultStatus = this.variableUtil.calVarInConf(content, "resultStatus")))) {
            content.putRequestSubValue("outputStatus", (Object)Integer.valueOf(resultStatus));
        }
        if (conf.containsKey((Object)"dataHandle")) {
            Object paramResult = this.inputUtil.getData(content);
            this.outputUtil.handleAndPutData(content, paramResult);
        }
        if (StringUtils.isNotEmpty((CharSequence)(resultCodeStr = this.variableUtil.calVarInConf(content, "resultCode"))) && !StringUtils.equals((CharSequence)resultCodeStr, (CharSequence)"normal_return")) {
            Integer status = 500;
            BizException bizException = new BizException();
            Object errorType = ProjectConfUtil.getArrayGlobalConf((ProcessContent)content, (String)"errorType");
            JSONArray errorArray = JSONArray.parseArray((String)JSONObject.toJSONString((Object)errorType));
            boolean isResultCode = true;
            if (CollectionUtils.isNotEmpty((Collection)errorArray)) {
                for (Object error : errorArray) {
                    JSONObject errorJsonObject = JSONObject.parseObject((String)JSONObject.toJSONString(error));
                    if (!Objects.nonNull(errorJsonObject) || !Objects.equals(errorJsonObject.getString("code"), resultCodeStr)) continue;
                    String msg = errorJsonObject.getString("name");
                    status = errorJsonObject.getInteger("status");
                    bizException.setResultStatus(status);
                    bizException.setCode(resultCodeStr);
                    bizException.setMsg(msg);
                    isResultCode = false;
                    break;
                }
            }
            if (isResultCode) {
                Boolean exist = ResultCode.exist((String)resultCodeStr);
                if (exist.booleanValue()) {
                    ResultCode resultCode = ResultCode.getResultCode((String)resultCodeStr);
                    bizException.setResultCode(resultCode);
                } else {
                    bizException.setCode(resultCodeStr);
                    bizException.setResultStatus(status);
                }
            }
            if (StringUtils.isNotEmpty((CharSequence)returnMsg)) {
                bizException.setMsg(returnMsg);
            }
            if (NumberUtil.isNumber((CharSequence)resultStatus)) {
                bizException.setResultStatus(Integer.valueOf(resultStatus));
            }
            bizException.setInterrupt(Integer.valueOf(3));
            bizException.putContent("id", (Object)content.getStep().getId());
            bizException.putContent("expression", (Object)expression);
            throw bizException;
        }
    }

    public String getName() {
        return "returnProcess";
    }
}

