/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.lowcode.manager;

import com.alibaba.fastjson.JSONObject;
import com.aliyun.oss.OSS;
import com.aliyun.oss.OSSClientBuilder;
import com.aliyun.oss.model.OSSObject;
import com.manatee.common.domain.ResultCode;
import com.manatee.common.exception.BizException;
import com.manatee.common.util.FileUtil;
import com.manatee.common.util.StringUtil;
import com.manatee.common.util.tool.core.io.IoUtil;
import com.manatee.config.oss.ManateeOssConfig;
import com.manatee.lowcode.util.GlobalConf;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Base64;
import java.util.Date;
import javax.annotation.Resource;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class OssManager {
    private static final Logger log = LoggerFactory.getLogger(OssManager.class);
    @Resource
    private ManateeOssConfig manateeOssConfig;

    public JSONObject uploadFile(String fileName, InputStream inputStream, String bucketName, String folder, Boolean autoCover) throws BizException {
        JSONObject result = new JSONObject();
        OSS ossClient = this.getOssClient();
        ByteArrayInputStream byteArrayInputStream = null;
        String ownDomain = this.manateeOssConfig.getOwnDomain();
        try {
            boolean exists = ossClient.doesBucketExist(bucketName);
            if (!exists) {
                ossClient.createBucket(bucketName);
            }
            byte[] fileBytes = IoUtil.readBytes((InputStream)inputStream);
            folder = StringUtil.isBlank((String)folder) ? "" : folder + "/";
            fileName = folder + FileUtil.getNewFileName((Boolean)autoCover, (String)fileName);
            byteArrayInputStream = new ByteArrayInputStream(fileBytes);
            ossClient.putObject(bucketName, fileName, (InputStream)new ByteArrayInputStream(fileBytes));
            if (StringUtil.isBlank((String)ownDomain)) {
                ownDomain = this.manateeOssConfig.getEndpoint();
            }
            String url = ownDomain + "/" + fileName;
            result.put("fileName", (Object)fileName);
            result.put("url", (Object)url);
            result.put("fileSize", (Object)fileBytes.length);
        }
        catch (Exception e) {
            throw new BizException(ResultCode.BIZ_ERROR, (Throwable)e);
        }
        finally {
            if (byteArrayInputStream != null) {
                try {
                    byteArrayInputStream.close();
                }
                catch (IOException e) {
                    log.error("\u5173\u95ed\u6d41\u5f02\u5e38", (Throwable)e);
                }
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    log.error("\u5173\u95ed\u6d41\u5f02\u5e38", (Throwable)e);
                }
            }
            try {
                ossClient.shutdown();
            }
            catch (Exception e) {
                log.error("\u5173\u95edossClient\u5f02\u5e38", (Throwable)e);
            }
        }
        return result;
    }

    public JSONObject uploadFileBase(String base, String bucketName, String folder, String suffix, Boolean autoCover) throws BizException {
        JSONObject result = new JSONObject();
        OSS ossClient = this.getOssClient();
        ByteArrayInputStream byteArrayInputStream = null;
        String ownDomain = this.manateeOssConfig.getOwnDomain();
        try {
            boolean exists = ossClient.doesBucketExist(bucketName);
            if (!exists) {
                ossClient.createBucket(bucketName);
            }
            byte[] imageByte = Base64.getDecoder().decode(base);
            folder = StringUtil.isBlank((String)folder) ? "" : folder + "/";
            String fileName = this.buildBase64Name(imageByte, suffix);
            fileName = folder + FileUtil.getNewFileName((Boolean)autoCover, (String)fileName);
            byteArrayInputStream = new ByteArrayInputStream(imageByte);
            ossClient.putObject(bucketName, fileName, (InputStream)byteArrayInputStream);
            if (StringUtil.isBlank((String)ownDomain)) {
                ownDomain = this.manateeOssConfig.getEndpoint();
            }
            String url = ownDomain + "/" + fileName;
            result.put("fileName", (Object)fileName);
            result.put("url", (Object)url);
            result.put("fileSize", (Object)imageByte.length);
        }
        catch (Exception e) {
            throw new BizException(ResultCode.BIZ_ERROR, (Throwable)e);
        }
        finally {
            if (byteArrayInputStream != null) {
                try {
                    byteArrayInputStream.close();
                }
                catch (IOException e) {
                    log.error("\u5173\u95ed\u6d41\u5f02\u5e38", (Throwable)e);
                }
            }
            try {
                ossClient.shutdown();
            }
            catch (Exception e) {
                log.error("\u5173\u95edossClient\u5f02\u5e38", (Throwable)e);
            }
        }
        return result;
    }

    public String downloadFile(String bucketName, String ossFileName, String downloadFileName) throws BizException {
        OSS ossClient = this.getOssClient();
        try {
            OSSObject ossObject = ossClient.getObject(bucketName, ossFileName);
            File tempDir = new File(GlobalConf.TEMP_DIRECTORY);
            if (!tempDir.exists()) {
                tempDir.mkdir();
            }
            File file = new File(tempDir + "/" + downloadFileName);
            try {
                FileUtils.copyToFile((InputStream)ossObject.getObjectContent(), (File)file);
            }
            catch (Exception e) {
                throw new BizException(ResultCode.SYSTEM_ERROR, "\u6587\u4ef6\u4e0d\u5b58\u5728");
            }
            if (!file.exists()) {
                throw new BizException(ResultCode.SYSTEM_ERROR, "\u6587\u4ef6\u4e0d\u5b58\u5728");
            }
            String string = file.getPath();
            return string;
        }
        catch (Exception e) {
            throw new BizException(ResultCode.BIZ_ERROR, (Throwable)e);
        }
        finally {
            try {
                ossClient.shutdown();
            }
            catch (Exception e) {
                log.error("\u5173\u95edossClient\u5f02\u5e38", (Throwable)e);
            }
        }
    }

    public void removeFile(String bucketName, String ossFileName) throws BizException {
        OSS ossClient = this.getOssClient();
        try {
            ossClient.deleteObject(bucketName, ossFileName);
        }
        catch (Exception e) {
            throw new BizException(ResultCode.BIZ_ERROR, (Throwable)e);
        }
        finally {
            try {
                ossClient.shutdown();
            }
            catch (Exception e) {
                log.error("\u5173\u95edossClient\u5f02\u5e38", (Throwable)e);
            }
        }
    }

    public URL getSignUrl(String bucketName, String ossFileName, Long hour) throws BizException {
        URL url;
        OSS ossClient = this.getOssClient();
        try {
            Date expiration = new Date(System.currentTimeMillis() + hour * 3600L * 1000L);
            url = ossClient.generatePresignedUrl(bucketName, ossFileName, expiration);
        }
        catch (Exception e) {
            throw new BizException(ResultCode.BIZ_ERROR, (Throwable)e);
        }
        finally {
            try {
                ossClient.shutdown();
            }
            catch (Exception e) {
                log.error("\u5173\u95edossClient\u5f02\u5e38", (Throwable)e);
            }
        }
        return url;
    }

    private OSS getOssClient() throws BizException {
        String endpoint = this.manateeOssConfig.getEndpoint();
        String accessKeyId = this.manateeOssConfig.getAccessKeyId();
        String secretAccessKey = this.manateeOssConfig.getSecretAccessKey();
        if (StringUtil.isBlank((String)endpoint) || StringUtil.isBlank((String)accessKeyId) || StringUtil.isBlank((String)secretAccessKey)) {
            throw new BizException(ResultCode.CONF_ERROR, "OSS endpoint/accessKey/secretKey \u914d\u7f6e\u9519\u8bef\u6216\u8005\u672a\u914d\u7f6e");
        }
        OSS ossClient = new OSSClientBuilder().build(endpoint, accessKeyId, secretAccessKey);
        return ossClient;
    }

    private String buildBase64Name(byte[] imageByte, String suffix) {
        try {
            String base64Str = Base64.getEncoder().encodeToString(imageByte);
            String fileName = DigestUtils.md5Hex((String)base64Str);
            StringBuilder sb = new StringBuilder();
            sb.append(fileName);
            sb.append(".");
            sb.append(suffix);
            return sb.toString();
        }
        catch (Exception e) {
            return "";
        }
    }
}

