/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.lowcode.function.time;

import com.manatee.common.util.TimeUtil;
import com.manatee.fun.AbstractFunction;
import com.manatee.fun.domain.FunctionContent;
import com.manatee.fun.util.FunctionContentUtil;
import java.util.Date;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class TimeFormatFun
extends AbstractFunction {
    private static Logger log = LoggerFactory.getLogger(TimeFormatFun.class);
    private String name = "timeFormat";

    public String getName() {
        return this.name;
    }

    public Object doFunction(FunctionContent content) {
        String toFormat;
        Date date;
        this.checkParamSize(content);
        if (!this.checkParamExist(content).booleanValue()) {
            return null;
        }
        Object timeStr = content.getParameter(0);
        if (content.getParameters().size() == 3) {
            String fromFormat = (String)content.getParameter(1);
            date = TimeUtil.getFunctionDate((Object)timeStr, (String)fromFormat);
            toFormat = (String)content.getParameter(2);
        } else {
            date = this.getDate(timeStr);
            toFormat = (String)content.getParameter(1);
        }
        try {
            return TimeUtil.format2Date((Date)date, (String)toFormat);
        }
        catch (Throwable e) {
            log.error("[TimeFormatFun.doFunction]_exception", e);
            FunctionContentUtil.addUnBlockError((FunctionContent)content, (String)String.format("\u51fd\u6570\uff1a%s\uff0c\u65f6\u95f4\u683c\u5f0f\u5316\u5f02\u5e38", this.getName()), (String)this.getName());
            return null;
        }
    }

    private Date getDate(Object dateObj) {
        Date resultDate;
        if (dateObj instanceof Date) {
            resultDate = (Date)dateObj;
        } else if (dateObj instanceof Double) {
            dateObj = ((Double)dateObj).longValue();
            resultDate = new Date(Long.parseLong(dateObj.toString()));
        } else {
            resultDate = Pattern.compile("[0-9]*").matcher(dateObj.toString()).matches() ? new Date(Long.parseLong(dateObj.toString())) : TimeUtil.parseStringToDate((String)dateObj.toString());
        }
        return resultDate;
    }

    public Integer getMinParamSize() {
        return 2;
    }

    public Integer getMaxParamSize() {
        return 3;
    }

    public static void main(String[] args) {
        FunctionContent content = new FunctionContent();
        content.setParameter((Object)"2018-07-01 00:00:00");
        content.setParameter((Object)"yyyy-MM-dd HH:mm:ss");
        content.setParameter((Object)"yyyyMMdd");
        System.out.println(new TimeFormatFun().doFunction(content));
    }
}

