/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.lowcode.function.change;

import com.manatee.fun.AbstractFunction;
import com.manatee.fun.domain.FunctionContent;
import com.manatee.fun.util.FunctionContentUtil;
import java.net.URLEncoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class URLEncoderFun
extends AbstractFunction {
    private static Logger LOGGER = LoggerFactory.getLogger(URLEncoderFun.class);

    public String getName() {
        return "urlEncoder";
    }

    public Object doFunction(FunctionContent content) {
        this.checkParamSize(content);
        if (!this.checkParamExist(content).booleanValue()) {
            return null;
        }
        Object obj = content.getParameter(0);
        Object charset = content.getParameter(1);
        try {
            if (obj instanceof String) {
                String str = (String)obj;
                return URLEncoder.encode(str, charset.toString());
            }
            FunctionContentUtil.addUnBlockError((FunctionContent)content, (String)String.format("\u51fd\u6570\uff1a%s\uff0curl\u5fc5\u987b\u4e3a\u5b57\u7b26\u4e32", this.getName()), (String)this.getName());
            return null;
        }
        catch (Throwable e) {
            LOGGER.error("[URLEncoderFun.doFunction]_exception", e);
            FunctionContentUtil.addUnBlockError((FunctionContent)content, (String)String.format("\u51fd\u6570\uff1a%s\uff0curl\u7f16\u7801\u5931\u8d25", this.getName()), (String)this.getName());
            return null;
        }
    }

    public Integer getMinParamSize() {
        return 2;
    }

    public Integer getMaxParamSize() {
        return 2;
    }
}

