/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.lowcode.domain;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.manatee.common.domain.ResultCode;
import com.manatee.common.domain.ResultTrace;
import com.manatee.common.exception.BizException;
import com.manatee.common.util.StringUtil;
import com.manatee.common.util.tool.core.collection.CollectionUtil;
import com.manatee.common.util.tool.core.map.MapUtil;
import com.manatee.lowcode.log.ManateeLoggerContext;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.slf4j.MDC;

public class WebResult {
    private JSONObject data;
    private JSONObject request;
    private JSONObject debug;
    private JSONObject warn;
    private JSONArray errorTrace;
    private JSONArray unBlockError;
    private ResultTrace resultTrace = new ResultTrace();
    private JSONObject backStructure = new JSONObject();
    private Boolean resultConvert = false;

    public void setData(Map<String, Object> value) {
        if (this.data == null) {
            this.data = new JSONObject(true);
        }
        this.data.putAll(value);
    }

    public void setData(List value) {
        if (this.data == null) {
            this.data = new JSONObject(true);
        }
        this.data.put("list", (Object)value);
    }

    public Object getDirectReturnData() {
        return this.data.get((Object)"_directReturnData");
    }

    public JSONObject getRequest() {
        return this.request;
    }

    public void setRequest(Map<String, Object> value) {
        if (this.request == null) {
            this.request = new JSONObject(true);
        }
        this.request.putAll(value);
    }

    public JSONObject toJson() {
        JSONObject value = new JSONObject(true);
        JSONObject customRseponse = new JSONObject();
        value.put("codeType", (Object)this.resultTrace.getCode());
        if (StringUtil.isNotBlank((String)this.resultTrace.getSubCode())) {
            value.put("codeDetail", (Object)this.resultTrace.getSubCode());
        } else {
            value.put("codeDetail", (Object)"");
        }
        if (StringUtil.isNotBlank((String)this.resultTrace.getMsg())) {
            value.put("msg", (Object)this.resultTrace.getMsg());
        }
        if (StringUtil.isNotBlank((String)MDC.get((String)"traceId"))) {
            value.put("traceId", (Object)MDC.get((String)"traceId"));
        }
        int status = this.getStatus();
        value.put("status", (Object)status);
        if (this.resultTrace.getId() >= 0) {
            value.put("errorCode", (Object)0);
            value.put("success", (Object)true);
        } else {
            value.put("errorCode", (Object)1);
            value.put("success", (Object)false);
        }
        if (this.data != null) {
            if (this.data.get((Object)"_directReturnData") != null) {
                if (this.resultConvert != null && this.resultConvert.booleanValue()) {
                    value.put("data", (Object)JSONObject.parseObject((String)JSONObject.toJSONString((Object)this.getDirectReturnData(), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}), (Feature[])new Feature[]{Feature.OrderedField}));
                } else {
                    value.put("data", this.getDirectReturnData());
                }
            } else if (this.resultConvert != null && this.resultConvert.booleanValue()) {
                value.put("data", (Object)JSONObject.parseObject((String)JSONObject.toJSONString((Object)this.getData(), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}), (Feature[])new Feature[]{Feature.OrderedField}));
            } else {
                value.put("data", (Object)this.getData());
            }
        } else {
            value.put("data", (Object)new JSONObject());
        }
        if (this.debug != null) {
            value.put("request", (Object)this.request);
            customRseponse.put("request", (Object)this.request);
            value.put("debug", (Object)this.debug);
            customRseponse.put("debug", (Object)this.debug);
            if (this.errorTrace != null) {
                value.put("errorTrace", (Object)this.errorTrace);
                customRseponse.put("errorTrace", (Object)this.errorTrace);
            }
            if (this.unBlockError != null) {
                value.put("unBlockError", (Object)this.unBlockError);
                customRseponse.put("unBlockError", (Object)this.unBlockError);
            }
            if (this.warn != null) {
                value.put("warn", (Object)this.warn);
                customRseponse.put("warn", (Object)this.warn);
            }
            String requestLogs = ManateeLoggerContext.getRequestLogs();
            this.debug.put("manateeLog", (Object)requestLogs);
            this.debug.put("manateeLogPath", (Object)MDC.get((String)"manateeLogPath"));
        }
        if (MapUtil.isNotEmpty((Map)this.backStructure) && this.backStructure.containsKey((Object)"selections")) {
            if (StringUtil.isNotBlank((String)MDC.get((String)"traceId"))) {
                customRseponse.put("traceId", (Object)MDC.get((String)"traceId"));
            }
            JSONArray selections = this.backStructure.getJSONArray("selections");
            JSONObject customKeys = this.backStructure.getJSONObject("customKeys");
            if (CollectionUtil.isNotEmpty((Collection)selections)) {
                for (Object selection : selections) {
                    customRseponse.put(customKeys.getString(selection.toString()), value.get((Object)selection.toString()));
                }
                MDC.clear();
                return customRseponse;
            }
        }
        MDC.clear();
        return value;
    }

    public int getStatus() {
        if (this.resultTrace.getResultStatus() != null) {
            return this.resultTrace.getResultStatus();
        }
        String code = this.resultTrace.getCode();
        String subCode = this.resultTrace.getSubCode();
        if (ResultCode.PARAM_IS_ERROR.getCode().equals(code)) {
            return 400;
        }
        if (ResultCode.NOT_AUTHORIZED.getCode().equals(code)) {
            return 401;
        }
        if ("process_not_found".equals(subCode)) {
            return 404;
        }
        if (ResultCode.METHOD_NOT_ALLOWED.getCode().equals(code)) {
            return 405;
        }
        if (ResultCode.SYSTEM_ERROR.getCode().equals(code)) {
            return 500;
        }
        if (ResultCode.BIZ_ERROR.getCode().equals(code)) {
            return 500;
        }
        if (ResultCode.CONF_ERROR.getCode().equals(code)) {
            return 510;
        }
        return 200;
    }

    public void setException(Throwable e) {
        BizException bizException;
        if (e instanceof BizException) {
            bizException = (BizException)e;
        } else if (e instanceof UndeclaredThrowableException) {
            UndeclaredThrowableException undeclare = (UndeclaredThrowableException)e;
            bizException = (BizException)undeclare.getUndeclaredThrowable();
        } else {
            bizException = new BizException(ResultCode.SYSTEM_ERROR, e);
        }
        this.resultTrace = bizException.getResultTrace();
    }

    public boolean isSuccess() {
        return this.resultTrace != null && this.resultTrace.getId() >= 0;
    }

    public void setResultCode(ResultCode resultCode) {
        this.resultTrace.setResultCode(resultCode);
    }

    public void setMsg(String msg) {
        this.resultTrace.setMsg(msg);
    }

    public JSONObject getData() {
        return this.data;
    }

    public JSONObject getDebug() {
        return this.debug;
    }

    public JSONObject getWarn() {
        return this.warn;
    }

    public JSONArray getErrorTrace() {
        return this.errorTrace;
    }

    public JSONArray getUnBlockError() {
        return this.unBlockError;
    }

    public ResultTrace getResultTrace() {
        return this.resultTrace;
    }

    public JSONObject getBackStructure() {
        return this.backStructure;
    }

    public Boolean getResultConvert() {
        return this.resultConvert;
    }

    public void setDebug(JSONObject debug) {
        this.debug = debug;
    }

    public void setWarn(JSONObject warn) {
        this.warn = warn;
    }

    public void setErrorTrace(JSONArray errorTrace) {
        this.errorTrace = errorTrace;
    }

    public void setUnBlockError(JSONArray unBlockError) {
        this.unBlockError = unBlockError;
    }

    public void setResultTrace(ResultTrace resultTrace) {
        this.resultTrace = resultTrace;
    }

    public void setBackStructure(JSONObject backStructure) {
        this.backStructure = backStructure;
    }

    public void setResultConvert(Boolean resultConvert) {
        this.resultConvert = resultConvert;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WebResult)) {
            return false;
        }
        WebResult other = (WebResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        JSONObject this$data = this.getData();
        JSONObject other$data = other.getData();
        if (this$data == null ? other$data != null : !this$data.equals(other$data)) {
            return false;
        }
        JSONObject this$request = this.getRequest();
        JSONObject other$request = other.getRequest();
        if (this$request == null ? other$request != null : !this$request.equals(other$request)) {
            return false;
        }
        JSONObject this$debug = this.getDebug();
        JSONObject other$debug = other.getDebug();
        if (this$debug == null ? other$debug != null : !this$debug.equals(other$debug)) {
            return false;
        }
        JSONObject this$warn = this.getWarn();
        JSONObject other$warn = other.getWarn();
        if (this$warn == null ? other$warn != null : !this$warn.equals(other$warn)) {
            return false;
        }
        JSONArray this$errorTrace = this.getErrorTrace();
        JSONArray other$errorTrace = other.getErrorTrace();
        if (this$errorTrace == null ? other$errorTrace != null : !this$errorTrace.equals(other$errorTrace)) {
            return false;
        }
        JSONArray this$unBlockError = this.getUnBlockError();
        JSONArray other$unBlockError = other.getUnBlockError();
        if (this$unBlockError == null ? other$unBlockError != null : !this$unBlockError.equals(other$unBlockError)) {
            return false;
        }
        ResultTrace this$resultTrace = this.getResultTrace();
        ResultTrace other$resultTrace = other.getResultTrace();
        if (this$resultTrace == null ? other$resultTrace != null : !this$resultTrace.equals(other$resultTrace)) {
            return false;
        }
        JSONObject this$backStructure = this.getBackStructure();
        JSONObject other$backStructure = other.getBackStructure();
        if (this$backStructure == null ? other$backStructure != null : !this$backStructure.equals(other$backStructure)) {
            return false;
        }
        Boolean this$resultConvert = this.getResultConvert();
        Boolean other$resultConvert = other.getResultConvert();
        return !(this$resultConvert == null ? other$resultConvert != null : !((Object)this$resultConvert).equals(other$resultConvert));
    }

    protected boolean canEqual(Object other) {
        return other instanceof WebResult;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        JSONObject $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        JSONObject $request = this.getRequest();
        result = result * 59 + ($request == null ? 43 : $request.hashCode());
        JSONObject $debug = this.getDebug();
        result = result * 59 + ($debug == null ? 43 : $debug.hashCode());
        JSONObject $warn = this.getWarn();
        result = result * 59 + ($warn == null ? 43 : $warn.hashCode());
        JSONArray $errorTrace = this.getErrorTrace();
        result = result * 59 + ($errorTrace == null ? 43 : $errorTrace.hashCode());
        JSONArray $unBlockError = this.getUnBlockError();
        result = result * 59 + ($unBlockError == null ? 43 : $unBlockError.hashCode());
        ResultTrace $resultTrace = this.getResultTrace();
        result = result * 59 + ($resultTrace == null ? 43 : $resultTrace.hashCode());
        JSONObject $backStructure = this.getBackStructure();
        result = result * 59 + ($backStructure == null ? 43 : $backStructure.hashCode());
        Boolean $resultConvert = this.getResultConvert();
        result = result * 59 + ($resultConvert == null ? 43 : ((Object)$resultConvert).hashCode());
        return result;
    }

    public String toString() {
        return "WebResult(data=" + this.getData() + ", request=" + this.getRequest() + ", debug=" + this.getDebug() + ", warn=" + this.getWarn() + ", errorTrace=" + this.getErrorTrace() + ", unBlockError=" + this.getUnBlockError() + ", resultTrace=" + this.getResultTrace() + ", backStructure=" + this.getBackStructure() + ", resultConvert=" + this.getResultConvert() + ")";
    }
}

