/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.excel.util;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.converters.Converter;
import com.alibaba.excel.metadata.data.WriteCellData;
import com.alibaba.excel.write.builder.ExcelWriterBuilder;
import com.alibaba.excel.write.builder.ExcelWriterSheetBuilder;
import com.alibaba.excel.write.handler.WriteHandler;
import com.alibaba.excel.write.merge.OnceAbsoluteMergeStrategy;
import com.alibaba.excel.write.metadata.WriteSheet;
import com.alibaba.excel.write.metadata.fill.FillConfig;
import com.alibaba.excel.write.metadata.fill.FillWrapper;
import com.alibaba.excel.write.metadata.style.WriteCellStyle;
import com.alibaba.excel.write.metadata.style.WriteFont;
import com.alibaba.fastjson.JSONObject;
import com.manatee.common.domain.ResultCode;
import com.manatee.common.exception.BizException;
import com.manatee.common.util.StringUtil;
import com.manatee.excel.domain.WriteExcelBO;
import com.manatee.excel.domain.WriteExcelTemplateBO;
import com.manatee.excel.util.CellMergedStrategy;
import com.manatee.excel.util.ExcelColumnWidthStyleStrategy;
import com.manatee.excel.util.ListConverter;
import com.manatee.excel.util.ProgressRowWriteHandler;
import com.manatee.excel.util.WaterMarkHandler;
import com.manatee.lowcode.util.CacheRamUtil;
import com.manatee.lowcode.util.GlobalConf;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.core.io.ClassPathResource;

public class ExceWriteUtil {
    public static boolean writeExcel(String file, List<WriteExcelBO> excelList) throws BizException {
        boolean result = false;
        ExcelWriter writer = null;
        try {
            writer = EasyExcel.write((String)file, List.class).build();
            for (WriteExcelBO excelBO : excelList) {
                WriteSheet sheet = ((ExcelWriterSheetBuilder)EasyExcel.writerSheet((String)excelBO.getSheetName()).needHead(Boolean.FALSE)).build();
                List<List<Object>> data = excelBO.getDataList();
                writer.write(data, sheet);
            }
            result = true;
        }
        catch (Throwable e) {
            throw new BizException(ResultCode.SYSTEM_ERROR, "write_excel_error", e);
        }
        finally {
            if (writer != null) {
                writer.finish();
            }
        }
        return result;
    }

    public static boolean writeExcelWithStyle(String file, List<WriteExcelBO> excelList, String fileExtension, String fileWatermark, String filePassword, JSONObject excelConf, CacheRamUtil cacheRamUtil) throws BizException {
        boolean result = false;
        ExcelWriter writer = null;
        ExcelWriterBuilder excelWriterBuilder = null;
        File tempFile = null;
        File originalFile = null;
        try {
            Boolean progressStatus;
            if (excelList == null || excelList.size() <= 0) {
                boolean bl = true;
                return bl;
            }
            boolean isHead = true;
            if (excelConf != null) {
                Boolean isAddition = excelConf.getBoolean("isAddition");
                if (isAddition != null && isAddition.booleanValue()) {
                    originalFile = new File(file);
                    if (originalFile.exists()) {
                        if (StringUtils.isBlank((CharSequence)fileExtension)) {
                            fileExtension = ".xls";
                        }
                        isHead = false;
                        String tempFileName = GlobalConf.TEMP_DIRECTORY + "manatee_temp_" + System.currentTimeMillis() + fileExtension;
                        tempFile = new File(tempFileName);
                        excelWriterBuilder = (ExcelWriterBuilder)EasyExcel.write((File)originalFile, List.class).withTemplate(originalFile).file(tempFile).needHead(Boolean.valueOf(false));
                    } else {
                        excelWriterBuilder = EasyExcel.write((String)file, List.class);
                    }
                } else {
                    excelWriterBuilder = EasyExcel.write((String)file, List.class);
                }
            } else {
                excelWriterBuilder = EasyExcel.write((String)file, List.class);
            }
            excelWriterBuilder.registerWriteHandler((WriteHandler)new ExcelColumnWidthStyleStrategy(excelList.get(0).getColumnWidthStyle()));
            int size = excelList.get(0).getHeadList().size();
            String titleName = excelList.get(0).getTitleName();
            if (isHead && StringUtil.isNotBlank((String)titleName) && size > 1) {
                OnceAbsoluteMergeStrategy onceAbsoluteMergeStrategy1 = new OnceAbsoluteMergeStrategy(0, 0, 0, size - 1);
                excelWriterBuilder.registerWriteHandler((WriteHandler)onceAbsoluteMergeStrategy1);
            }
            String summaryInfo = excelList.get(0).getSummaryInfo();
            if (isHead && StringUtils.isNotBlank((CharSequence)summaryInfo) && size > 1) {
                OnceAbsoluteMergeStrategy onceAbsoluteMergeStrategy2 = new OnceAbsoluteMergeStrategy(1, 1, 0, size - 1);
                excelWriterBuilder.registerWriteHandler((WriteHandler)onceAbsoluteMergeStrategy2);
            }
            if (StringUtils.isNotBlank((CharSequence)fileExtension) && StringUtils.equals((CharSequence)fileExtension, (CharSequence)".xlsx")) {
                if (StringUtils.isNotEmpty((CharSequence)fileWatermark)) {
                    excelWriterBuilder.inMemory(Boolean.valueOf(true)).registerWriteHandler((WriteHandler)new WaterMarkHandler(fileWatermark));
                }
                if (StringUtils.isNotEmpty((CharSequence)filePassword)) {
                    excelWriterBuilder.password(filePassword);
                }
            }
            if (excelConf != null && (progressStatus = excelConf.getBoolean("progressStatus")) != null && progressStatus.booleanValue()) {
                int totalCount = 0;
                for (WriteExcelBO excelBO : excelList) {
                    totalCount += excelBO.getDataList2(isHead).size();
                }
                String progressCacheKey = excelConf.getString("progressCacheKey");
                int progressCacheTime = excelConf.getInteger("progressCacheTime");
                int progressCount = excelConf.getInteger("progressCount");
                String fileName = excelConf.getString("fileName");
                excelWriterBuilder.registerWriteHandler((WriteHandler)new ProgressRowWriteHandler(cacheRamUtil, progressCacheKey, progressCacheTime, totalCount, progressCount, fileName));
            }
            writer = excelWriterBuilder.build();
            for (WriteExcelBO excelBO : excelList) {
                WriteSheet sheet = ((ExcelWriterSheetBuilder)EasyExcel.writerSheet((String)excelBO.getSheetName()).needHead(Boolean.FALSE)).build();
                List<List<Object>> data = excelBO.getDataList2(isHead);
                writer.write(data, sheet);
            }
            result = true;
        }
        catch (Throwable e) {
            throw new BizException(ResultCode.SYSTEM_ERROR, "write_excel_error", e);
        }
        finally {
            if (writer != null) {
                writer.finish();
            }
        }
        if (tempFile != null && tempFile.exists()) {
            originalFile.delete();
            tempFile.renameTo(originalFile);
        }
        return result;
    }

    public static boolean writeExcelTemplate(String file, List<WriteExcelTemplateBO> excelList, String filePath, String fileWatermark, String filePassword) throws BizException {
        boolean result = false;
        ExcelWriter writer = null;
        InputStream inputStreamTemp = null;
        try {
            if (filePath.indexOf("classpath:") == 0) {
                ClassPathResource classPathResource = new ClassPathResource(filePath.replace("classpath:", ""));
                inputStreamTemp = classPathResource.getInputStream();
            } else {
                File fileTempData = new File(filePath);
                inputStreamTemp = new FileInputStream(fileTempData);
            }
            XSSFWorkbook workbookTemp = new XSSFWorkbook(inputStreamTemp);
            ArrayList<String> sheetNameList = new ArrayList<String>();
            for (WriteExcelTemplateBO excelBO : excelList) {
                sheetNameList.add(excelBO.getSheetName());
                if (StringUtils.equals((CharSequence)excelBO.getSheetName(), (CharSequence)excelBO.getTempSheetName())) continue;
                int sheetNum = workbookTemp.getSheetIndex(excelBO.getTempSheetName());
                workbookTemp.cloneSheet(sheetNum, excelBO.getSheetName());
            }
            int numberOfSheets = workbookTemp.getNumberOfSheets();
            for (int i = numberOfSheets - 1; i >= 0; --i) {
                XSSFSheet sheet = workbookTemp.getSheetAt(i);
                if (sheetNameList.contains(sheet.getSheetName())) continue;
                int sheetIndex = workbookTemp.getSheetIndex((Sheet)sheet);
                workbookTemp.removeSheetAt(sheetIndex);
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            workbookTemp.write((OutputStream)baos);
            byte[] bytes = baos.toByteArray();
            ByteArrayInputStream inputStreamNew = new ByteArrayInputStream(bytes);
            ExcelWriterBuilder excelWriterBuilder = (ExcelWriterBuilder)((ExcelWriterBuilder)EasyExcel.write((String)file).withTemplate((InputStream)inputStreamNew).registerWriteHandler((WriteHandler)new CellMergedStrategy())).registerConverter((Converter)new ListConverter());
            if (StringUtils.isNotEmpty((CharSequence)fileWatermark)) {
                excelWriterBuilder.inMemory(Boolean.valueOf(true)).registerWriteHandler((WriteHandler)new WaterMarkHandler(fileWatermark));
            }
            if (StringUtils.isNotEmpty((CharSequence)filePassword)) {
                excelWriterBuilder.password(filePassword);
            }
            writer = excelWriterBuilder.build();
            if (excelList == null || excelList.size() <= 0) {
                boolean bl = true;
                return bl;
            }
            for (WriteExcelTemplateBO excelBO : excelList) {
                Map<String, Object> one;
                FillConfig fillConfig;
                WriteSheet sheet = ((ExcelWriterSheetBuilder)EasyExcel.writerSheet((String)excelBO.getSheetName()).needHead(Boolean.FALSE)).build();
                List<Map<String, Object>> list = excelBO.getList();
                Map<String, List<Map<String, Object>>> batchList = excelBO.getBatchList();
                if (list != null) {
                    fillConfig = FillConfig.builder().forceNewRow(Boolean.TRUE).build();
                    writer.fill(list, fillConfig, sheet);
                } else if (batchList != null && batchList.size() > 0) {
                    fillConfig = FillConfig.builder().forceNewRow(Boolean.TRUE).build();
                    for (Map.Entry<String, List<Map<String, Object>>> aMap : batchList.entrySet()) {
                        writer.fill((Object)new FillWrapper(aMap.getKey(), (Collection)aMap.getValue()), fillConfig, sheet);
                    }
                }
                if ((one = excelBO.getOne()) == null) continue;
                writer.fill(one, sheet);
            }
            result = true;
        }
        catch (Exception e) {
            throw new BizException(ResultCode.SYSTEM_ERROR, "write_excel_error", (Throwable)e);
        }
        finally {
            if (writer != null) {
                writer.finish();
            }
            if (inputStreamTemp != null) {
                try {
                    inputStreamTemp.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return result;
    }

    public static void main(String[] args) {
        String fileName = "/Users/apple/Desktop/11.xlsx";
        ArrayList list = new ArrayList();
        ArrayList<WriteCellData> row = new ArrayList<WriteCellData>();
        list.add(row);
        for (int i = 0; i < 10; ++i) {
            WriteCellData writeCellStyle = new WriteCellData("\u5355\u5143\u683c\u6837\u5f0f" + i);
            row.add(writeCellStyle);
            WriteCellStyle writeCellStyleData = new WriteCellStyle();
            writeCellStyle.setWriteCellStyle(writeCellStyleData);
            writeCellStyleData.setFillPatternType(FillPatternType.SOLID_FOREGROUND);
            writeCellStyleData.setFillForegroundColor(Short.valueOf(IndexedColors.GREEN.getIndex()));
            WriteFont writeFont = new WriteFont();
            writeFont.setColor(Short.valueOf(IndexedColors.GREEN.getIndex()));
            writeCellStyleData.setWriteFont(writeFont);
        }
        ((ExcelWriterSheetBuilder)EasyExcel.write((String)fileName).inMemory(Boolean.valueOf(true)).sheet("\u6a21\u677f").needHead(Boolean.FALSE)).doWrite(list);
    }

    public static boolean writeExcel(WriteExcelBO excelBO) throws BizException {
        boolean result = false;
        ExcelWriter writer = null;
        try {
            List<List<Object>> data = excelBO.getDataList();
            writer = EasyExcel.write((String)excelBO.getFile(), List.class).build();
            WriteSheet sheet = ((ExcelWriterSheetBuilder)EasyExcel.writerSheet((String)excelBO.getSheetName()).needHead(Boolean.FALSE)).build();
            writer.write(data, sheet);
            result = true;
        }
        catch (Throwable e) {
            throw new BizException(ResultCode.SYSTEM_ERROR, "write_excel_error", e);
        }
        finally {
            if (writer != null) {
                writer.finish();
            }
        }
        return result;
    }
}

