/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.xxljob;

import com.alibaba.fastjson.JSONObject;
import com.manatee.common.domain.ResultCode;
import com.manatee.common.exception.BizException;
import com.manatee.common.util.JSONUtils;
import com.manatee.lowcode.domain.ModularityResult;
import com.manatee.lowcode.web.manager.ModularityManager;
import com.xxl.job.core.context.XxlJobHelper;
import com.xxl.job.core.handler.annotation.XxlJob;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ModularityXxljob {
    @Autowired
    private ModularityManager modularityManager;

    @XxlJob(value="modularityJobHandler")
    public void modularityJobHandler() throws BizException {
        String jobParam = XxlJobHelper.getJobParam();
        XxlJobHelper.log((String)jobParam, (Object[])new Object[0]);
        if (!JSONUtils.isJson((String)jobParam)) {
            throw new BizException(ResultCode.SYSTEM_ERROR, "params is not json");
        }
        JSONObject jobParamJson = JSONObject.parseObject((String)jobParam);
        Long projectId = jobParamJson.getLong("projectId");
        String code = jobParamJson.getString("code");
        if (projectId == null || code == null) {
            throw new BizException(ResultCode.SYSTEM_ERROR, "projectId or code is null");
        }
        JSONObject params = jobParamJson.getJSONObject("params");
        ModularityResult modularityResult = this.modularityManager.executionModule(projectId, code, (Map)params);
        XxlJobHelper.log((String)JSONObject.toJSONString((Object)modularityResult), (Object[])new Object[0]);
    }
}

