/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.redis.process;

import com.manatee.common.exception.BizException;
import com.manatee.lowcode.iutil.IProcessConfUtil;
import com.manatee.lowcode.iutil.IVariableUtil;
import com.manatee.process.IProcess;
import com.manatee.process.domain.ProcessContent;
import com.manatee.redis.source.DtSourceManager;
import com.manatee.redis.util.RedisDbUtil;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class RedisSetValueAddProcess
implements IProcess {
    private Logger log = LoggerFactory.getLogger(RedisSetValueAddProcess.class);
    @Resource
    private DtSourceManager dtSourceManager;
    @Resource
    private IVariableUtil variableUtil;
    @Resource
    private IProcessConfUtil processConfUtil;

    public void process(ProcessContent content) throws BizException {
        String[] arrValues;
        this.processConfUtil.checkConf(content, new String[]{"key"});
        int db = RedisDbUtil.getRedisDB(content);
        String objectKey = this.variableUtil.calVarInConf(content, "key");
        Object value = content.getRequestSubValue(this.variableUtil.calVarInConf(content, "input"));
        if (value instanceof List) {
            List stringList = (List)value;
            ArrayList<String> listValues = new ArrayList<String>();
            for (Object o : stringList) {
                listValues.add(o.toString());
            }
            arrValues = listValues.toArray(new String[stringList.size()]);
        } else {
            arrValues = new String[]{value.toString()};
        }
        long ret = this.dtSourceManager.getDtSource().sadd(db, objectKey, arrValues);
        content.putValueToContent((Object)ret);
        this.log.warn("[RedisAddValToSetProcess.process]_biz_occur,msg:{}", (Object)("result:" + ret));
    }

    public String getName() {
        return "redisSetValueAdd";
    }
}

