/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.quartz.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.manatee.common.util.tool.core.text.CharSequenceUtil;
import com.manatee.lowcode.domain.ModularityResult;
import com.manatee.lowcode.web.manager.ModularityManager;
import com.manatee.lowcodedb.base.DBReadUtil;
import com.manatee.lowcodedb.newdb.DbClient;
import com.manatee.lowcodedb.newdb.DbEntity;
import com.manatee.lowcodedb.newdb.ds.DSFactory;
import com.manatee.lowcodedb.newdb.ds.DataSourceWrapper;
import com.manatee.lowcodedb.newdb.sql.SqlBuilder;
import com.manatee.manager.SpringContextManager;
import com.manatee.quartz.QuartzJobService;
import com.manatee.quartz.constants.ScheduleConstants;
import com.manatee.quartz.domain.QuartzJob;
import com.manatee.quartz.domain.QuartzJobLog;
import com.manatee.quartz.util.CronUtils;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.commons.lang3.StringUtils;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.BeanUtils;

public abstract class AbstractQuartzJob
implements Job {
    private static final Logger log = LoggerFactory.getLogger(AbstractQuartzJob.class);
    private static ThreadLocal<Date> threadLocal = new ThreadLocal();
    private DBReadUtil dbReadUtil = (DBReadUtil)SpringContextManager.getBean(DBReadUtil.class);
    private QuartzJobService quartzJobService = (QuartzJobService)SpringContextManager.getBean(QuartzJobService.class);
    private ModularityManager modularityManager = (ModularityManager)SpringContextManager.getBean(ModularityManager.class);

    public void execute(JobExecutionContext context) throws JobExecutionException {
        String traceId = System.currentTimeMillis() + "";
        MDC.put((String)"traceId", (String)traceId);
        QuartzJob quartzJob = new QuartzJob();
        BeanUtils.copyProperties((Object)context.getMergedJobDataMap().get((Object)"TASK_PROPERTIES"), (Object)quartzJob);
        boolean isExecute = this.before(context, quartzJob);
        if (!isExecute) {
            return;
        }
        QuartzJobLog jobLog = this.insertQuartzJobLog(quartzJob);
        try {
            if (quartzJob != null) {
                this.doExecute(context, quartzJob);
            }
            this.after(context, quartzJob, null, jobLog);
        }
        catch (Exception e) {
            log.error("\u4efb\u52a1\u6267\u884c\u5f02\u5e38  - \uff1a", (Throwable)e);
            this.after(context, quartzJob, e, jobLog);
        }
    }

    protected boolean before(JobExecutionContext context, QuartzJob quartzJob) {
        if (quartzJob == null) {
            return false;
        }
        QuartzJob quartzJobNew = this.getQuartzJob(quartzJob.getId());
        if (quartzJobNew == null) {
            return false;
        }
        if (!this.canContinueExecute(quartzJobNew).booleanValue()) {
            return false;
        }
        Date executeTime = context.getFireTime();
        if (quartzJob.getExecuteType() == 1 && quartzJobNew.getExecuteTime() != null) {
            Long executeTimeOld = quartzJobNew.getExecuteTime().getTime() / 1000L;
            Long executeTimeNew = executeTime.getTime() / 1000L;
            if (executeTimeOld >= executeTimeNew) {
                log.info("\u4efb\u52a1\u88ab\u96c6\u7fa4\u4e2d\u5176\u5b83\u8282\u70b9\u62a2\u5148\u6267\u884c\u3010{}\u3011", (Object)quartzJobNew.getJobName());
                return false;
            }
        }
        if (this.updateQuartzJobExecuteNum(quartzJobNew, executeTime) != 1) {
            log.info("\u4efb\u52a1\u88ab\u96c6\u7fa4\u4e2d\u5176\u5b83\u8282\u70b9\u62a2\u5148\u6267\u884c\u3010{}\u3011", (Object)quartzJobNew.getJobName());
            return false;
        }
        return true;
    }

    protected void after(JobExecutionContext context, QuartzJob quartzJob, Exception e, QuartzJobLog jobLog) {
        this.updateQuartzJobLog(context, e, jobLog);
        boolean isRetry = this.retry(quartzJob, StringUtils.equals((CharSequence)jobLog.getStatus(), (CharSequence)"0"));
        if (!isRetry) {
            this.callback(quartzJob, jobLog);
        }
    }

    protected abstract void doExecute(JobExecutionContext var1, QuartzJob var2) throws Exception;

    private void insertQuartzJobLog(QuartzJobLog jobLog) {
        if (null == jobLog) {
            return;
        }
        String lowcodeQuartzJobLog = "lowcode_quartz_job_log";
        String pk = "id";
        String defaultDatabaseProductName = this.quartzJobService.getDefaultDatabaseProductName();
        if (defaultDatabaseProductName.equals("dameng") || defaultDatabaseProductName.equals("oracle")) {
            lowcodeQuartzJobLog = "LOWCODE_QUARTZ_JOB_LOG";
            pk = "ID";
        }
        try {
            DataSourceWrapper dataSource = (DataSourceWrapper)DSFactory.get((String)"");
            String dataBaseName = dataSource.getDataBaseName();
            JSONObject jsonObject = JSONObject.parseObject((String)JSONObject.toJSONString((Object)jobLog));
            ArrayList<JSONObject> insertListParams = new ArrayList<JSONObject>();
            for (Map.Entry param : jsonObject.entrySet()) {
                JSONObject paramJson = new JSONObject();
                String fieldName = CharSequenceUtil.toUnderlineCase((CharSequence)((CharSequence)param.getKey()));
                if (defaultDatabaseProductName.equals("dameng") || defaultDatabaseProductName.equals("oracle")) {
                    fieldName = fieldName.toUpperCase();
                }
                paramJson.put("fieldName", (Object)fieldName);
                if (StringUtils.equals((CharSequence)fieldName.toLowerCase(), (CharSequence)"start_time")) {
                    paramJson.put("fieldValue", (Object)jobLog.getStartTime());
                } else if (StringUtils.equals((CharSequence)fieldName.toLowerCase(), (CharSequence)"stop_time")) {
                    paramJson.put("fieldValue", (Object)jobLog.getStopTime());
                } else {
                    paramJson.put("fieldValue", param.getValue());
                }
                insertListParams.add(paramJson);
            }
            DbEntity dbEntity = DbEntity.create((String)(dataBaseName + '.' + lowcodeQuartzJobLog)).setInsertTypeEnum(SqlBuilder.InsertTypeEnum.valueOfString((String)"insert")).setInsertConditionList(insertListParams);
            dbEntity.setPk(pk);
            DbClient.use((String)"").insertForGeneratedKey(dbEntity);
        }
        catch (Exception e) {
            log.error("\u4efb\u52a1\u6267\u884c\u65e5\u5fd7\u5165\u5e93\u5f02\u5e38\uff1a", (Throwable)e);
        }
    }

    private Boolean canContinueExecute(QuartzJob job) {
        long expiringDateMillis;
        long effectiveDateMillis;
        if (!StringUtils.equals((CharSequence)job.getStatus(), (CharSequence)"0")) {
            log.info("\u4efb\u52a1\u7ba1\u7406\u4e2d\u6b64\u4efb\u52a1\u5df2\u88ab\u7981\u7528\u3010{}\u3011", (Object)job.getJobName());
            return false;
        }
        long toDayMillis = this.quartzJobService.getDatasourceTime().getTime();
        if (job.getEffectiveDate() != null && toDayMillis < (effectiveDateMillis = job.getEffectiveDate().getTime())) {
            log.info("\u4efb\u52a1\u6267\u884c\u65f6\u95f4\u5c0f\u4e8e\u751f\u6548\u65f6\u95f4\u3010{}\u3011", (Object)job.getJobName());
            return false;
        }
        if (job.getExpiringDate() != null && toDayMillis > (expiringDateMillis = job.getExpiringDate().getTime()) + 86400000L) {
            log.info("\u4efb\u52a1\u6267\u884c\u65f6\u95f4\u5927\u4e8e\u5931\u6548\u65f6\u95f4\u3010{}\u3011", (Object)job.getJobName());
            return false;
        }
        return true;
    }

    private QuartzJob getQuartzJob(Long id) {
        try {
            String table = "lowcode_quartz_job";
            HashMap<String, Number> whereMap = new HashMap<String, Number>(2);
            whereMap.put("valid", 0);
            whereMap.put("id", id);
            JSONArray quartzJobArr = this.dbReadUtil.queryDbEntity(table, whereMap);
            if (quartzJobArr != null && quartzJobArr.size() > 0) {
                List quartzJobList = quartzJobArr.toJavaList(QuartzJob.class);
                return (QuartzJob)quartzJobList.get(0);
            }
        }
        catch (Throwable e) {
            log.error("\u67e5\u8be2\u5b9a\u65f6\u4efb\u52a1\u5f02\u5e38\uff1a", e);
        }
        return null;
    }

    private int updateQuartzJobExecuteNum(QuartzJob job, Date executeTime) {
        if (null == job) {
            return 0;
        }
        String lowcodeQuartzJob = "lowcode_quartz_job";
        String pk = "id";
        String executeNum = "execute_num";
        String executeTimeKey = "execute_time";
        String defaultDatabaseProductName = this.quartzJobService.getDefaultDatabaseProductName();
        if (defaultDatabaseProductName.equals("dameng") || defaultDatabaseProductName.equals("oracle")) {
            lowcodeQuartzJob = "LOWCODE_QUARTZ_JOB";
            pk = "ID";
            executeNum = "EXECUTE_NUM";
            executeTimeKey = "EXECUTE_TIME";
        }
        try {
            DataSourceWrapper dataSource = (DataSourceWrapper)DSFactory.get((String)"");
            String dataBaseName = dataSource.getDataBaseName();
            ArrayList<JSONObject> whereListParams = new ArrayList<JSONObject>();
            JSONObject whereJson1 = new JSONObject();
            whereJson1.put("fieldName", (Object)pk);
            whereJson1.put("symbol", (Object)"=");
            whereJson1.put("condition", (Object)"and");
            whereJson1.put("fieldValue", (Object)job.getId());
            whereListParams.add(whereJson1);
            JSONObject whereJson2 = new JSONObject();
            whereJson2.put("fieldName", (Object)executeNum);
            whereJson2.put("fieldValue", (Object)job.getExecuteNum());
            whereJson2.put("symbol", (Object)"=");
            whereJson2.put("condition", (Object)"and");
            whereListParams.add(whereJson2);
            DbEntity whereDbEntity = DbEntity.create((String)(dataBaseName + '.' + lowcodeQuartzJob)).setWhereConditionListForDbQuery(lowcodeQuartzJob, whereListParams);
            ArrayList<JSONObject> updateListParams = new ArrayList<JSONObject>();
            JSONObject updateJson1 = new JSONObject();
            updateJson1.put("fieldName", (Object)executeNum);
            Integer executeNumValue = job.getExecuteNum();
            if (executeNumValue == null) {
                executeNumValue = 0;
            }
            updateJson1.put("fieldValue", (Object)(executeNumValue + 1));
            updateListParams.add(updateJson1);
            JSONObject updateJson2 = new JSONObject();
            updateJson2.put("fieldName", (Object)executeTimeKey);
            updateJson2.put("fieldValue", (Object)executeTime);
            updateListParams.add(updateJson2);
            DbEntity updateDbEntity = DbEntity.create((String)(dataBaseName + '.' + lowcodeQuartzJob)).setInsertConditionList(updateListParams);
            int updateCount = DbClient.use((String)"").update(updateDbEntity, whereDbEntity);
            return updateCount;
        }
        catch (Exception e) {
            log.error("\u66f4\u65b0\u6267\u884c\u6b21\u6570\u5f02\u5e38\uff1a", (Throwable)e);
            return 0;
        }
    }

    private boolean retry(QuartzJob job, boolean executeStatus) {
        Integer retriedNum;
        QuartzJob quartzJobNew = this.getQuartzJob(job.getId());
        if (quartzJobNew == null || !StringUtils.equals((CharSequence)quartzJobNew.getRetryStatus(), (CharSequence)"0")) {
            return false;
        }
        if (executeStatus) {
            if (quartzJobNew.getRetriedNum() != null && quartzJobNew.getRetriedNum() > 0 && this.updateQuartzJobRetriedNum(quartzJobNew, 0, null) >= 1) {
                this.quartzJobService.createScheduleJob(quartzJobNew);
            }
            return false;
        }
        Integer retryNum = quartzJobNew.getRetryNum();
        if (retryNum == null) {
            retryNum = 0;
        }
        if ((retriedNum = quartzJobNew.getRetriedNum()) == null) {
            retriedNum = 0;
        }
        if (retryNum - retriedNum <= 0) {
            if (StringUtils.isBlank((CharSequence)quartzJobNew.getFailIsStop()) || StringUtils.equals((CharSequence)quartzJobNew.getFailIsStop(), (CharSequence)"1")) {
                if (this.updateQuartzJobRetriedNum(quartzJobNew, 0, "1") >= 1) {
                    quartzJobNew.setStatus(ScheduleConstants.Status.PAUSE.getValue());
                    this.quartzJobService.createScheduleJob(quartzJobNew);
                }
            } else if (this.updateQuartzJobRetriedNum(quartzJobNew, 0, "0") >= 1) {
                quartzJobNew.setStatus(ScheduleConstants.Status.NORMAL.getValue());
                this.quartzJobService.createScheduleJob(quartzJobNew);
            }
            return false;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(this.quartzJobService.getDatasourceTime());
        Integer retryInterval = quartzJobNew.getRetryInterval();
        if (quartzJobNew.getRetryIntervalUnit() == 1) {
            if (null == retryInterval || retryInterval < 10) {
                retryInterval = 10;
            }
            calendar.add(13, retryInterval);
        } else if (quartzJobNew.getRetryIntervalUnit() == 2) {
            if (null == retryInterval || retryInterval < 1) {
                retryInterval = 1;
            }
            calendar.add(12, retryInterval);
        } else if (quartzJobNew.getRetryIntervalUnit() == 3) {
            if (null == retryInterval || retryInterval < 1) {
                retryInterval = 1;
            }
            calendar.add(11, retryInterval);
        }
        if (this.updateQuartzJobRetriedNum(quartzJobNew, retriedNum + 1, null) >= 1) {
            quartzJobNew.setRetriedNum(retriedNum + 1);
            this.quartzJobService.modifyJobTime(quartzJobNew, CronUtils.getCron(calendar.getTime()));
        }
        return true;
    }

    private int updateQuartzJobRetriedNum(QuartzJob job, Integer retriedNum, String status) {
        if (null == job) {
            return 0;
        }
        String lowcodeQuartzJob = "lowcode_quartz_job";
        String pk = "id";
        String retriedNumKey = "retried_num";
        String statusKey = "status";
        String runStatusKey = "run_status";
        String defaultDatabaseProductName = this.quartzJobService.getDefaultDatabaseProductName();
        if (defaultDatabaseProductName.equals("dameng") || defaultDatabaseProductName.equals("oracle")) {
            lowcodeQuartzJob = "LOWCODE_QUARTZ_JOB";
            pk = "ID";
            retriedNumKey = "RETRIED_NUM";
            statusKey = "STATUS";
            runStatusKey = "RUN_STATUS";
        }
        try {
            DataSourceWrapper dataSource = (DataSourceWrapper)DSFactory.get((String)"");
            String dataBaseName = dataSource.getDataBaseName();
            ArrayList<JSONObject> whereListParams = new ArrayList<JSONObject>();
            JSONObject whereJson1 = new JSONObject();
            whereJson1.put("fieldName", (Object)pk);
            whereJson1.put("symbol", (Object)"=");
            whereJson1.put("condition", (Object)"and");
            whereJson1.put("fieldValue", (Object)job.getId());
            whereListParams.add(whereJson1);
            if (retriedNum != null && retriedNum != 0) {
                JSONObject whereJson2 = new JSONObject();
                whereJson2.put("fieldName", (Object)retriedNumKey);
                whereJson2.put("fieldValue", (Object)job.getRetriedNum());
                whereJson2.put("symbol", (Object)"=");
                whereJson2.put("condition", (Object)"and");
                whereListParams.add(whereJson2);
            }
            DbEntity whereDbEntity = DbEntity.create((String)(dataBaseName + '.' + lowcodeQuartzJob)).setWhereConditionListForDbQuery(lowcodeQuartzJob, whereListParams);
            ArrayList<JSONObject> updateListParams = new ArrayList<JSONObject>();
            JSONObject updateJson1 = new JSONObject();
            updateJson1.put("fieldName", (Object)retriedNumKey);
            updateJson1.put("fieldValue", (Object)retriedNum);
            updateListParams.add(updateJson1);
            if (StringUtils.isNotEmpty((CharSequence)status)) {
                JSONObject updateJson2 = new JSONObject();
                updateJson2.put("fieldName", (Object)statusKey);
                updateJson2.put("fieldValue", (Object)status);
                updateListParams.add(updateJson2);
                if (StringUtils.equals((CharSequence)status, (CharSequence)"1")) {
                    JSONObject updateJson3 = new JSONObject();
                    updateJson3.put("fieldName", (Object)runStatusKey);
                    updateJson3.put("fieldValue", (Object)"5");
                    updateListParams.add(updateJson3);
                }
            }
            DbEntity updateDbEntity = DbEntity.create((String)(dataBaseName + '.' + lowcodeQuartzJob)).setInsertConditionList(updateListParams);
            int updateCount = DbClient.use((String)"").update(updateDbEntity, whereDbEntity);
            return updateCount;
        }
        catch (Exception e) {
            log.error("\u66f4\u65b0\u4efb\u52a1\u6267\u884c\u6b21\u6570\u5f02\u5e38\uff1a", (Throwable)e);
            return 0;
        }
    }

    private void callback(QuartzJob job, QuartzJobLog jobLog) {
        String callbackStatus;
        Map resultMap;
        if (StringUtils.equals((CharSequence)job.getCallbackStatus(), (CharSequence)"1") || StringUtils.isEmpty((CharSequence)job.getCallbackModuleCode())) {
            return;
        }
        Long projectId = job.getProjectId();
        String code = job.getCallbackModuleCode();
        HashMap<String, Object> callbackParams = new HashMap<String, Object>(3);
        callbackParams.put("status", jobLog.getStatus());
        callbackParams.put("jobLogId", jobLog.getId());
        callbackParams.put("jobId", job.getId());
        log.info("quartz job \u56de\u8c03\u5f00\u59cb\uff0cprojectId\uff1a{}\uff0ccode\uff1a{}. params\uff1a{}", new Object[]{projectId, code, callbackParams});
        ModularityResult modularityResult = this.modularityManager.executionModule(projectId, code, callbackParams);
        log.info("quartz job \u56de\u8c03\u7ed3\u675f\uff1a{}", (Object)JSONObject.toJSONString((Object)modularityResult));
        boolean isCallback = false;
        if (modularityResult != null && modularityResult.isSuccess() && (resultMap = modularityResult.getData()).containsKey("callbackStatus") && StringUtils.equals((CharSequence)(callbackStatus = (String)resultMap.get("callbackStatus")), (CharSequence)"SUCCESS")) {
            isCallback = true;
        }
        if (!isCallback) {
            job.setCallbackParams(JSONObject.toJSONString(callbackParams));
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(this.quartzJobService.getDatasourceTime());
            calendar.add(13, 30);
            if (calendar.getTimeInMillis() < System.currentTimeMillis()) {
                calendar.setTimeInMillis(System.currentTimeMillis());
                calendar.add(13, 30);
            }
            String cron = CronUtils.getCron(calendar.getTime());
            job.setCallbackCron(cron);
            job.setCallbackNum(1);
            this.quartzJobService.createCallbackJob(job);
            log.info("\u4efb\u52a1\u3010{}\u3011\u56de\u8c03\u901a\u77e5\u5931\u8d25\uff0c\u521b\u5efa\u56de\u8c03\u4efb\u52a1\uff0c\u6267\u884ccron\u8868\u8fbe\u5f0f\uff1a{}", (Object)job.getJobName(), (Object)cron);
        }
    }

    private QuartzJobLog insertQuartzJobLog(QuartzJob quartzJob) {
        Date startTime = this.quartzJobService.getDatasourceTime();
        QuartzJobLog jobLog = new QuartzJobLog();
        String logId = System.currentTimeMillis() + "" + ThreadLocalRandom.current().nextInt(1000, 9999);
        jobLog.setId(Long.parseLong(logId));
        jobLog.setJobId(quartzJob.getId());
        jobLog.setJobName(quartzJob.getJobName());
        jobLog.setJobGroup(quartzJob.getJobGroup());
        jobLog.setJobModuleCode(quartzJob.getJobModuleCode());
        jobLog.setJobParams(quartzJob.getJobParams());
        jobLog.setStartTime(startTime);
        jobLog.setStatus("2");
        jobLog.setExecuteType(quartzJob.getExecuteType());
        threadLocal.set(new Date());
        String lowcodeQuartzJobLog = "lowcode_quartz_job_log";
        String pk = "id";
        String defaultDatabaseProductName = this.quartzJobService.getDefaultDatabaseProductName();
        if (defaultDatabaseProductName.equals("dameng") || defaultDatabaseProductName.equals("oracle")) {
            lowcodeQuartzJobLog = "LOWCODE_QUARTZ_JOB_LOG";
            pk = "ID";
        }
        try {
            DataSourceWrapper dataSource = (DataSourceWrapper)DSFactory.get((String)"");
            String dataBaseName = dataSource.getDataBaseName();
            JSONObject jsonObject = JSONObject.parseObject((String)JSONObject.toJSONString((Object)jobLog));
            ArrayList<JSONObject> insertListParams = new ArrayList<JSONObject>();
            for (Map.Entry param : jsonObject.entrySet()) {
                JSONObject paramJson = new JSONObject();
                String fieldName = CharSequenceUtil.toUnderlineCase((CharSequence)((CharSequence)param.getKey()));
                if (defaultDatabaseProductName.equals("dameng") || defaultDatabaseProductName.equals("oracle")) {
                    fieldName = fieldName.toUpperCase();
                }
                paramJson.put("fieldName", (Object)fieldName);
                if (StringUtils.equals((CharSequence)fieldName.toLowerCase(), (CharSequence)"start_time")) {
                    paramJson.put("fieldValue", (Object)jobLog.getStartTime());
                } else if (StringUtils.equals((CharSequence)fieldName.toLowerCase(), (CharSequence)"stop_time")) {
                    paramJson.put("fieldValue", (Object)jobLog.getStopTime());
                } else {
                    paramJson.put("fieldValue", param.getValue());
                }
                insertListParams.add(paramJson);
            }
            DbEntity dbEntity = DbEntity.create((String)(dataBaseName + '.' + lowcodeQuartzJobLog)).setInsertTypeEnum(SqlBuilder.InsertTypeEnum.valueOfString((String)"insert")).setInsertConditionList(insertListParams);
            dbEntity.setPk(pk);
            DbClient.use((String)"").insertForGeneratedKey(dbEntity);
            this.updateQuartzJobRunStatus(quartzJob.getId(), "2");
        }
        catch (Exception e) {
            log.error("\u4efb\u52a1\u6267\u884c\u65e5\u5fd7\u5165\u5e93\u5f02\u5e38\uff1a", (Throwable)e);
        }
        return jobLog;
    }

    private void updateQuartzJobLog(JobExecutionContext context, Exception e, QuartzJobLog jobLog) {
        String status;
        if (jobLog == null) {
            return;
        }
        Date startTime = threadLocal.get();
        threadLocal.remove();
        Date stopTime = this.quartzJobService.getDatasourceTime();
        long runMs = System.currentTimeMillis() - startTime.getTime();
        String jobMessage = jobLog.getJobName() + " \u603b\u5171\u8017\u65f6\uff1a" + runMs + "\u6beb\u79d2";
        String errorMsg = "";
        String jobResult = "";
        if (e != null) {
            status = "1";
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter((Writer)sw, true));
            errorMsg = StringUtils.substring((String)sw.toString(), (int)0, (int)1000);
        } else {
            status = "0";
            ModularityResult modularityResult = (ModularityResult)context.getResult();
            if (modularityResult != null) {
                jobResult = StringUtils.substring((String)JSONObject.toJSONString((Object)modularityResult), (int)0, (int)1000);
                if (!modularityResult.isSuccess()) {
                    status = "1";
                    errorMsg = StringUtils.substring((String)modularityResult.getMsg(), (int)0, (int)1000);
                }
            }
        }
        jobLog.setStatus(status);
        String lowcodeQuartzJobLog = "lowcode_quartz_job_log";
        String pk = "id";
        String stopTimeKey = "stop_time";
        String jobMessageKey = "job_message";
        String statusKey = "status";
        String jobResultKey = "job_result";
        String exceptionInfoKey = "exception_info";
        String defaultDatabaseProductName = this.quartzJobService.getDefaultDatabaseProductName();
        if (defaultDatabaseProductName.equals("dameng") || defaultDatabaseProductName.equals("oracle")) {
            lowcodeQuartzJobLog = "LOWCODE_QUARTZ_JOB_LOG";
            pk = "ID";
            stopTimeKey = "STOP_TIME";
            jobMessageKey = "JOB_MESSAGE";
            statusKey = "STATUS";
            jobResultKey = "JOB_RESULT";
            exceptionInfoKey = "EXCEPTION_INFO";
        }
        try {
            DataSourceWrapper dataSource = (DataSourceWrapper)DSFactory.get((String)"");
            String dataBaseName = dataSource.getDataBaseName();
            ArrayList<JSONObject> whereListParams = new ArrayList<JSONObject>();
            JSONObject whereJson1 = new JSONObject();
            whereJson1.put("fieldName", (Object)pk);
            whereJson1.put("symbol", (Object)"=");
            whereJson1.put("condition", (Object)"and");
            whereJson1.put("fieldValue", (Object)jobLog.getId());
            whereListParams.add(whereJson1);
            DbEntity whereDbEntity = DbEntity.create((String)(dataBaseName + '.' + lowcodeQuartzJobLog)).setWhereConditionListForDbQuery(lowcodeQuartzJobLog, whereListParams);
            ArrayList<JSONObject> updateListParams = new ArrayList<JSONObject>();
            JSONObject updateJson1 = new JSONObject();
            updateJson1.put("fieldName", (Object)statusKey);
            updateJson1.put("fieldValue", (Object)status);
            updateListParams.add(updateJson1);
            JSONObject updateJson2 = new JSONObject();
            updateJson2.put("fieldName", (Object)stopTimeKey);
            updateJson2.put("fieldValue", (Object)stopTime);
            updateListParams.add(updateJson2);
            JSONObject updateJson3 = new JSONObject();
            updateJson3.put("fieldName", (Object)jobMessageKey);
            updateJson3.put("fieldValue", (Object)jobMessage);
            updateListParams.add(updateJson3);
            JSONObject updateJson4 = new JSONObject();
            updateJson4.put("fieldName", (Object)jobResultKey);
            updateJson4.put("fieldValue", (Object)jobResult);
            updateListParams.add(updateJson4);
            JSONObject updateJson5 = new JSONObject();
            updateJson5.put("fieldName", (Object)exceptionInfoKey);
            updateJson5.put("fieldValue", (Object)errorMsg);
            updateListParams.add(updateJson5);
            DbEntity updateDbEntity = DbEntity.create((String)(dataBaseName + '.' + lowcodeQuartzJobLog)).setInsertConditionList(updateListParams);
            int updateCount = DbClient.use((String)"").update(updateDbEntity, whereDbEntity);
            String runStatus = "4";
            if (StringUtils.equals((CharSequence)status, (CharSequence)"0")) {
                runStatus = "3";
            }
            this.updateQuartzJobRunStatus(jobLog.getJobId(), runStatus);
        }
        catch (Exception e1) {
            log.error("\u4efb\u52a1\u6267\u884c\u65e5\u5fd7\u5165\u5e93\u5f02\u5e38\uff1a", (Throwable)e1);
        }
    }

    private int updateQuartzJobRunStatus(Long jobId, String runStatus) {
        if (null == jobId) {
            return 0;
        }
        String lowcodeQuartzJob = "lowcode_quartz_job";
        String pk = "id";
        String runStatusKey = "run_status";
        String defaultDatabaseProductName = this.quartzJobService.getDefaultDatabaseProductName();
        if (defaultDatabaseProductName.equals("dameng") || defaultDatabaseProductName.equals("oracle")) {
            lowcodeQuartzJob = "LOWCODE_QUARTZ_JOB";
            pk = "ID";
            runStatusKey = "RUN_STATUS";
        }
        try {
            DataSourceWrapper dataSource = (DataSourceWrapper)DSFactory.get((String)"");
            String dataBaseName = dataSource.getDataBaseName();
            ArrayList<JSONObject> whereListParams = new ArrayList<JSONObject>();
            JSONObject whereJson1 = new JSONObject();
            whereJson1.put("fieldName", (Object)pk);
            whereJson1.put("symbol", (Object)"=");
            whereJson1.put("condition", (Object)"and");
            whereJson1.put("fieldValue", (Object)jobId);
            whereListParams.add(whereJson1);
            DbEntity whereDbEntity = DbEntity.create((String)(dataBaseName + '.' + lowcodeQuartzJob)).setWhereConditionListForDbQuery(lowcodeQuartzJob, whereListParams);
            ArrayList<JSONObject> updateListParams = new ArrayList<JSONObject>();
            JSONObject updateJson1 = new JSONObject();
            updateJson1.put("fieldName", (Object)runStatusKey);
            updateJson1.put("fieldValue", (Object)runStatus);
            updateListParams.add(updateJson1);
            DbEntity updateDbEntity = DbEntity.create((String)(dataBaseName + '.' + lowcodeQuartzJob)).setInsertConditionList(updateListParams);
            int updateCount = DbClient.use((String)"").update(updateDbEntity, whereDbEntity);
            return updateCount;
        }
        catch (Exception e) {
            log.error("\u66f4\u65b0\u4efb\u52a1\u8fd0\u884c\u72b6\u6001\u5f02\u5e38\uff1a", (Throwable)e);
            return 0;
        }
    }
}

