/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.fun.impl.time;

import com.manatee.common.util.TimeUtil;
import com.manatee.fun.AbstractFunction;
import com.manatee.fun.domain.FunctionContent;
import java.util.Date;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class TimeIsOutFun
extends AbstractFunction {
    private static Logger LOGGER = LoggerFactory.getLogger(TimeIsOutFun.class);

    public String getName() {
        return "timeIsOut";
    }

    public Object doFunction(FunctionContent content) {
        Date date;
        Date now = new Date();
        this.checkParamSize(content);
        if (!this.checkParamExist(content).booleanValue()) {
            throw new RuntimeException(String.format("\u51fd\u6570\uff1a%s\uff0c\u53c2\u6570\u4e0d\u80fd\u4e3anull", this.getName()));
        }
        Object timeStr = content.getParameter(0);
        if (content.getParameters().size() > 1) {
            String fromFormat = (String)content.getParameter(1);
            date = TimeUtil.getFunctionDate((Object)timeStr, (String)fromFormat);
        } else {
            date = this.getDate(timeStr);
        }
        return date.before(now);
    }

    private Date getDate(Object dateObj) {
        Date resultDate;
        if (dateObj instanceof Date) {
            resultDate = (Date)dateObj;
        } else if (dateObj instanceof Double) {
            dateObj = ((Double)dateObj).longValue();
            resultDate = new Date(Long.parseLong(dateObj.toString()));
        } else {
            resultDate = Pattern.compile("[0-9]*").matcher(dateObj.toString()).matches() ? new Date(Long.parseLong(dateObj.toString())) : TimeUtil.parseStringToDate((String)dateObj.toString());
        }
        return resultDate;
    }

    public Integer getMinParamSize() {
        return 1;
    }

    public Integer getMaxParamSize() {
        return 2;
    }
}

