/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.fun.impl.change;

import com.manatee.common.util.tool.core.util.NumberUtil;
import com.manatee.fun.AbstractFunction;
import com.manatee.fun.domain.FunctionContent;
import com.manatee.fun.util.FunctionContentUtil;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class LongFun
extends AbstractFunction {
    private static Logger log = LoggerFactory.getLogger(LongFun.class);
    private String name = "long";

    public String getName() {
        return this.name;
    }

    public Object doFunction(FunctionContent content) {
        this.checkParamSize(content);
        if (!this.checkParamExist(content).booleanValue()) {
            return 0L;
        }
        Object obj = content.getParameter(0);
        long result = 0L;
        try {
            if (obj instanceof Long) {
                result = (Long)obj;
            } else if (obj instanceof Double) {
                Double d = (Double)obj;
                result = d.longValue();
            } else if (obj instanceof Integer) {
                Integer l2 = (Integer)obj;
                result = l2.longValue();
            } else if (obj instanceof BigInteger) {
                BigInteger bi = (BigInteger)obj;
                result = bi.longValue();
            } else if (obj instanceof BigDecimal) {
                BigDecimal bd = (BigDecimal)obj;
                result = bd.longValue();
            } else if (obj instanceof Float) {
                Float f = (Float)obj;
                result = f.longValue();
            } else if (obj instanceof Boolean) {
                Boolean b = (Boolean)obj;
                result = b != false ? 1L : 0L;
            } else {
                String s = (String)obj;
                if (NumberUtil.isNumber((CharSequence)s)) {
                    result = Double.valueOf(s).longValue();
                }
            }
            return result;
        }
        catch (Throwable e) {
            log.error("[LongFun.doFunction]_exception", e);
            FunctionContentUtil.addUnBlockError((FunctionContent)content, (String)String.format("\u51fd\u6570\uff1a%s\uff0c\u8f6clong\u5931\u8d25", this.getName()), (String)this.getName());
            return null;
        }
    }

    public Integer getMinParamSize() {
        return 1;
    }

    public Integer getMaxParamSize() {
        return 1;
    }
}

