/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.mongo.store;

import com.alibaba.fastjson.JSONObject;
import com.manatee.common.domain.ResultCode;
import com.manatee.common.exception.BizException;
import com.manatee.lowcode.iutil.IInputUtil;
import com.manatee.lowcode.iutil.IProcessConfUtil;
import com.manatee.lowcode.iutil.IVariableUtil;
import com.manatee.lowcode.util.OutputUtil;
import com.manatee.mongo.MongoWriteUtil;
import com.manatee.process.IProcess;
import com.manatee.process.domain.ProcessContent;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class MongoAddProcess
implements IProcess {
    @Resource
    protected IInputUtil inputUtil;
    @Resource
    private IProcessConfUtil processConfUtil;
    @Resource
    private MongoWriteUtil mongoWriteUtil;
    @Resource
    protected OutputUtil outputUtil;
    @Resource
    private IVariableUtil variableUtil;

    public void process(ProcessContent content) throws BizException {
        JSONObject conf = content.getStepConf();
        this.processConfUtil.checkConf(content, new String[]{"table"});
        this.insertData(content, conf);
    }

    public void insertData(ProcessContent content, JSONObject conf) throws BizException {
        String db = this.variableUtil.calVarInConf(content, "db");
        String table = conf.getString("table");
        String handleType = conf.getString("handleType");
        if ("batch".equals(handleType)) {
            if (!conf.containsKey((Object)"paramsKey")) {
                throw new BizException(ResultCode.PARAM_IS_ERROR, "paramsKey_is_null");
            }
            Object insertParamsObject = this.inputUtil.getHandleData(content, "insertParams");
            if (insertParamsObject != null) {
                List insertParams = (List)insertParamsObject;
                this.mongoWriteUtil.insertList(db, table, insertParams);
                this.outputUtil.setDefaultReturnKey(content, "count");
                this.outputUtil.putData(content, (Object)insertParams.size());
            }
        } else {
            Map param = this.inputUtil.getHandleObject(content, "insertParams");
            if (param == null || param.size() == 0) {
                return;
            }
            Object insertId = this.mongoWriteUtil.insert(db, table, param);
            this.outputUtil.setDefaultReturnKey(content, "id");
            this.outputUtil.putData(content, (Object)insertId.toString());
        }
    }

    public String getName() {
        return "mongoAdd";
    }
}

