/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.mongo.enums;

import com.manatee.common.domain.ResultCode;
import com.manatee.common.exception.BizException;

public enum MongoOperationTypeEnum {
    INSERT_ONE("insertOne"),
    INSERT_MANY("insertMany"),
    FIND_ONE("findOne"),
    FIND("find"),
    UPDATE_ONE("updateOne"),
    UPDATE_MANY("updateMany"),
    DELETE_ONE("deleteOne"),
    DELETE_MANY("deleteMany"),
    AGGREGATE("aggregate"),
    COUNT("count"),
    COUNT_DOCUMENT("count_document"),
    ESTIMATED_DOCUMENT_COUNT("estimatedDocumentCount");

    private String code;

    public static MongoOperationTypeEnum fromOperationType(String code) throws BizException {
        MongoOperationTypeEnum[] mongoOperationTypeEnums;
        for (MongoOperationTypeEnum mongoOperationTypeEnum : mongoOperationTypeEnums = MongoOperationTypeEnum.values()) {
            if (!mongoOperationTypeEnum.code.equals(code)) continue;
            return mongoOperationTypeEnum;
        }
        throw new BizException(ResultCode.SYSTEM_ERROR, String.format("\u4e0d\u652f\u6301%s\u64cd\u4f5c\u7c7b\u578b", code));
    }

    private MongoOperationTypeEnum(String code) {
        this.code = code;
    }

    public String getCode() {
        return this.code;
    }
}

