/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.file.process;

import com.manatee.common.domain.ResultCode;
import com.manatee.common.exception.BizException;
import com.manatee.lowcode.util.ProcessConfUtil;
import com.manatee.lowcode.util.VariableUtil;
import com.manatee.process.IProcess;
import com.manatee.process.domain.ProcessContent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UnZipProcess
implements IProcess {
    private static Logger LOGGER = LoggerFactory.getLogger(UnZipProcess.class);
    @Autowired
    private ProcessConfUtil processConfUtil;
    @Resource
    private VariableUtil variableUtil;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void process(ProcessContent content) throws BizException {
        this.processConfUtil.checkConf(content, new String[]{"filePath"});
        this.processConfUtil.checkConf(content, new String[]{"destDirPath"});
        String filePath = this.variableUtil.calVarInConf(content, "filePath");
        String destDirPath = this.variableUtil.calVarInConf(content, "destDirPath");
        File file = new File(filePath);
        if (!file.exists()) {
            throw new RuntimeException(file.getPath() + "\u6240\u6307\u6587\u4ef6\u4e0d\u5b58\u5728");
        }
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(file);
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (entry.isDirectory()) {
                    String dirPath = destDirPath + "/" + entry.getName();
                    File dir = new File(dirPath);
                    dir.mkdirs();
                    continue;
                }
                InputStream is = null;
                FileOutputStream os = null;
                try {
                    int len;
                    File targetFile = new File(destDirPath + "/" + entry.getName());
                    if (!targetFile.getParentFile().exists()) {
                        targetFile.getParentFile().mkdirs();
                    }
                    if (targetFile.exists()) {
                        targetFile.delete();
                    }
                    targetFile.createNewFile();
                    is = zipFile.getInputStream(entry);
                    os = new FileOutputStream(targetFile);
                    byte[] buf = new byte[8192];
                    while ((len = is.read(buf)) != -1) {
                        os.write(buf, 0, len);
                    }
                }
                catch (Exception e) {
                    throw e;
                }
                finally {
                    if (os != null) {
                        os.close();
                    }
                    if (is == null) continue;
                    is.close();
                }
            }
            if (zipFile == null) return;
        }
        catch (Exception e) {
            try {
                LOGGER.error("UnZipProcess error ,filePath:\u3010{}\u3011, destDirPath:\u3010{}\u3011", new Object[]{filePath, destDirPath, e});
                throw new BizException(ResultCode.CONF_ERROR, (Throwable)e);
            }
            catch (Throwable throwable) {
                if (zipFile == null) throw throwable;
                try {
                    zipFile.close();
                    throw throwable;
                }
                catch (IOException e2) {
                    LOGGER.error("stream close error ,filePath:\u3010{}\u3011, destDirPath:\u3010{}\u3011", new Object[]{filePath, destDirPath, e2});
                }
                throw throwable;
            }
        }
        try {
            zipFile.close();
            return;
        }
        catch (IOException e) {
            LOGGER.error("stream close error ,filePath:\u3010{}\u3011, destDirPath:\u3010{}\u3011", new Object[]{filePath, destDirPath, e});
            return;
        }
    }

    public String getName() {
        return "unZip";
    }
}

