/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.file.process;

import com.manatee.common.domain.ResultCode;
import com.manatee.common.exception.BizException;
import com.manatee.file.base.FtpUtilsFactory;
import com.manatee.lowcode.iutil.IOutputUtil;
import com.manatee.lowcode.util.VariableUtil;
import com.manatee.process.IProcess;
import com.manatee.process.domain.ProcessContent;
import java.io.IOException;
import javax.annotation.Resource;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class FtpDeleteProcess
implements IProcess {
    private static Logger LOGGER = LoggerFactory.getLogger(FtpDeleteProcess.class);
    @Resource
    private FtpUtilsFactory ftpUtilsFactory;
    @Resource
    private IOutputUtil outputUtil;
    @Resource
    private VariableUtil variableUtil;

    public void process(ProcessContent content) throws BizException {
        String deleteType = content.getStepConf().getString("deleteType");
        String filePath = this.variableUtil.calVarInConf(content, "filePath");
        String foldPath = this.variableUtil.calVarInConf(content, "foldPath");
        String returnKey = this.variableUtil.calVarInConf(content, "returnKey");
        if ("filePath".equals(deleteType) && filePath == null) {
            throw new BizException(ResultCode.CONF_ERROR, "\u8bf7\u586b\u5199\u6587\u4ef6\u8def\u5f84");
        }
        if ("foldPath".equals(deleteType) && foldPath == null) {
            throw new BizException(ResultCode.CONF_ERROR, "\u8bf7\u586b\u5199\u76ee\u5f55\u8def\u5f84");
        }
        FTPClient ftpClient = this.ftpUtilsFactory.connectServer(content);
        int deleteNum = 0;
        try {
            if ("filePath".equals(deleteType)) {
                deleteNum = ftpClient.deleteFile(filePath) ? 1 : 0;
            } else if ("foldPath".equals(deleteType)) {
                deleteNum = FtpDeleteProcess.deleteDirectory(ftpClient, foldPath);
            }
        }
        catch (IOException e) {
            LOGGER.error("FTP\u5220\u9664\u6587\u4ef6\u5f02\u5e38", (Throwable)e);
            throw new BizException(ResultCode.CONF_ERROR, "FTP\u5220\u9664\u6587\u4ef6\u5931\u8d25 - ", (Throwable)e);
        }
        finally {
            FtpUtilsFactory.disconnect(ftpClient);
        }
        this.outputUtil.setDefaultReturnKey(content, returnKey);
        this.outputUtil.handleAndPutData(content, (Object)deleteNum);
    }

    private static int deleteDirectory(FTPClient ftpClient, String parentDir) throws IOException {
        int deleteNum = 0;
        ftpClient.enterLocalPassiveMode();
        ftpClient.setFileType(2);
        ftpClient.setFileTransferMode(2);
        FTPFile[] subFiles = ftpClient.listFiles(parentDir);
        if (subFiles != null && subFiles.length > 0) {
            for (FTPFile ftpFile : subFiles) {
                String currentFileName = ftpFile.getName();
                if (currentFileName.equals(".") || currentFileName.equals("..")) continue;
                String currentFilePath = parentDir + "/" + currentFileName;
                if (ftpFile.isDirectory()) {
                    deleteNum += FtpDeleteProcess.deleteDirectory(ftpClient, currentFilePath);
                    continue;
                }
                ftpClient.deleteFile(currentFilePath);
                ++deleteNum;
            }
        }
        return deleteNum += ftpClient.removeDirectory(parentDir) ? 1 : 0;
    }

    public String getName() {
        return "ftpDelete";
    }
}

